<?php 
 class class_mediaBase implements interface_mediabase { private $depth = NULLSTR; private $dbconnected = false; private $mySQL; private $curSongRating = NULLSTR; private $curSongRatingBy = NULLSTR; private $curSongComment = NULLSTR; private $curSongCommentBy = NULLSTR; private $genreWhitelist; private $genreWhitelistActive; private $genreBlacklist; private $rateWhitelist; private $rateWhitelistActive; private $rateBlacklist; function __construct($aDepth = NULLSTR) { global $cfg_mySQL_host; global $cfg_mySQL_port; global $cfg_mySQL_user; global $cfg_mySQL_passwd; global $cfg_mySQL_dataBase; global $cfg_genreWhitelist, $cfg_genreBlacklist; global $cfg_rateWhitelist, $cfg_rateBlacklist; $this->depth = $aDepth; try { $this->mySQL = @new mysqli($cfg_mySQL_host, $cfg_mySQL_user, $cfg_mySQL_passwd, $cfg_mySQL_dataBase, $cfg_mySQL_port); $this->dbconnected = true; mysqli_set_charset($this->mySQL, 'utf8'); } catch (Exception $e) { echo eventLog('mysql connection failed: '.mysqli_connect_error(), $this->depth); } $this->curSong = NULLSTR; $this->curSongFound = false; $this->findSongReset(); $this->genreWhitelist = $cfg_genreWhitelist; $this->genreWhitelistActive = (count($this->genreWhitelist) > 0 && trim($this->genreWhitelist[0]) != NULLSTR); $this->genreBlacklist = $cfg_genreBlacklist; $this->rateWhitelist = $cfg_rateWhitelist; $this->rateWhitelistActive = (count($this->rateWhitelist) > 0 && trim($this->rateWhitelist[0]) != NULLSTR); $this->rateBlacklist = $cfg_rateBlacklist; } function getLastMsg() { return $this->lastMsg; } function query_getInterpretById($aId) { $queryInt = "SELECT `interpret` FROM `table_interpret` WHERE `id` = $aId"; $queryResult = $this->mySQL->query($queryInt); $obj = $queryResult->fetch_object(); if (isset($obj->interpret)) return $obj->interpret; else return QUESTMARK; } function query_getAlbumById($aId) { $queryInt = "SELECT `album` FROM `table_album` WHERE `id` = $aId"; $queryResult = $this->mySQL->query($queryInt); $obj = $queryResult->fetch_object(); if (isset($obj->album)) return $obj->album; else return NULLSTR; } function query_getGenreById($aId) { $queryInt = "SELECT `genre` FROM `table_genre` WHERE `id` = $aId"; $queryResult = $this->mySQL->query($queryInt); $obj = $queryResult->fetch_object(); if (isset($obj->genre)) return $obj->genre; else return NULLSTR; } function getSearchResult($aSeachStr, $aOffset = 0, $aLimit = 0, $aDL_level = false, $aCaseSensitive = false) { $result = array(); if ($this->dbconnected) { $soPatLen = strlen(SO_INTERPRET); $checkSearchParam = substr($aSeachStr, 0, $soPatLen); switch ($checkSearchParam) { case SO_INTERPRET: { $seachStr = substr($aSeachStr, $soPatLen); $whereClause = "WHERE `interpret` LIKE '%$seachStr%'"; break; } case SO_TITLE: { $seachStr = substr($aSeachStr, $soPatLen); $whereClause = "WHERE `title` LIKE '%$seachStr%'"; break; } case SO_ALBUM: { $seachStr = substr($aSeachStr, $soPatLen); $whereClause = "WHERE `album` LIKE '%$seachStr%'"; break; } case SO_GENRE: { $seachStr = substr($aSeachStr, $soPatLen); $whereClause = "WHERE `genre` LIKE '%$seachStr%'"; break; } case SO_GENRE: { $seachStr = substr($aSeachStr, $soPatLen); $whereClause = "WHERE `comment` LIKE '%$seachStr%'"; break; } default: $seachStr = $aSeachStr; $whereClause = "WHERE `interpret` LIKE '%$seachStr%' OR `title` LIKE '%$seachStr%' OR `album` LIKE '%$seachStr%' OR `rating` LIKE '%$seachStr%' OR `ratingBy` LIKE '%$seachStr%' OR `comment` LIKE '%$seachStr%' OR `commentBy` LIKE '%$seachStr%' OR `year` LIKE '%$seachStr%' OR `genre` LIKE '%$seachStr%'"; } $seachStr = str_replace('*', '%', $seachStr); $limit = ($aLimit == 0) ? NULLSTR : ",$aLimit"; $query = "SELECT table_base.absolute AS absolute, table_interpret.interpret AS interpret, table_base.title AS title, table_base.playtime AS playtime, table_album.album AS album, table_base.rating AS rating, table_base.comment AS comment, table_genre.genre AS genre FROM `table_base` LEFT JOIN table_interpret ON (table_base.interpretID = table_interpret.id) LEFT JOIN table_album ON (table_base.albumID = table_album.id) LEFT JOIN table_genre ON (table_base.genreID = table_genre.id) $whereClause LIMIT $aOffset $limit"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { $genre = (isset($row->genre)) ? $row->genre : NULLSTR; if ( !in_array($genre, $this->genreBlacklist) && (!$this->genreWhitelistActive || in_array($genre, $this->genreWhitelist)) ) { $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpret)) ? $row->interpret : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : QUESTMARK; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->album)) ? $row->album : NULLSTR; $subArray['r'] = (isset($row->rating)) ? $row->rating : NULLSTR; $subArray['c'] = (isset($row->comment)) ? $row->comment : NULLSTR; $result[] = $subArray; } } $queryResult->close(); } return $result; } function getSearchResultByUser($aUser, $aOffset = 0, $aLimit = 0, $aCaseSensitive = false) { $result = array(); if ($this->dbconnected) { $aUser = str_replace('*', '%', $aUser); $limit = ($aLimit == 0) ? NULLSTR : ",$aLimit"; $query = "SELECT table_base.absolute AS absolute, table_interpret.interpret AS interpret, table_base.title AS title, table_base.playtime AS playtime, table_album.album AS album, table_base.rating AS rating, table_base.comment AS comment, table_genre.genre AS genre FROM `table_base` LEFT JOIN table_interpret ON(table_base.interpretID = table_interpret.id) LEFT JOIN table_album ON(table_base.albumID = table_album.id) LEFT JOIN table_genre ON(table_base.genreID = table_genre.id) WHERE `ratingBy` LIKE '%$aUser%' OR `commentBy` LIKE '%$aUser%' LIMIT $aOffset $limit"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { $genre = (isset($row->genre)) ? $row->genre : NULLSTR; if ( !in_array($genre, $this->genreBlacklist) && (!$this->genreWhitelistActive || in_array($genre, $this->genreWhitelist)) ) { $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpret)) ? $row->interpret : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : NULLSTR; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->album)) ? $row->album : NULLSTR; $subArray['r'] = (isset($row->rating)) ? $row->rating : NULLSTR; $subArray['c'] = (isset($row->comment)) ? $row->comment : NULLSTR; $result[] = $subArray; } } $queryResult->close(); } return $result; } function getSongsByDate($aDate1, $aDate2, $aOffset = 0, $aLimit = 0) { $result = array(); if ($this->dbconnected) { $limit = ($aLimit == 0) ? NULLSTR : ",$aLimit"; $past = intval($aDate1); $today = intval($aDate2); $query = "SELECT table_base.absolute AS absolute, table_base.filedate AS filedate, table_interpret.interpret AS interpret, table_base.title AS title, table_base.playtime AS playtime, table_album.album AS album, table_base.rating AS rating, table_base.comment AS comment, table_genre.genre AS genre FROM `table_base` LEFT JOIN table_interpret ON(table_base.interpretID = table_interpret.id) LEFT JOIN table_album ON(table_base.albumID = table_album.id) LEFT JOIN table_genre ON(table_base.genreID = table_genre.id) ORDER BY `filedate` DESC LIMIT $aOffset $limit"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { $year = substr($row->filedate, 0, 4); $month = substr($row->filedate, 5, 2); $day = substr($row->filedate, 8, 2); $fileDate = intval($year.$month.$day); if ($fileDate >= $past && $fileDate <= $today) { $genre = (isset($row->genre)) ? $row->genre : NULLSTR; if ( !in_array($genre, $this->genreBlacklist) && (!$this->genreWhitelistActive || in_array($genre, $this->genreWhitelist)) ) { $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpret)) ? $row->interpret : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : NULLSTR; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->album)) ? $row->album : NULLSTR; $subArray['r'] = (isset($row->rating)) ? $row->rating : NULLSTR; $subArray['c'] = (isset($row->comment)) ? $row->comment : NULLSTR; $result[] = $subArray; } } } } return $result; } function getRandomSongs($value) { $result = array(); if ($this->dbconnected) { $count = $this->getTotalSongCount(); $max = ($count > $value) ? $value : $count; $query = "SELECT table_base.absolute AS absolute, table_interpret.interpret AS interpret, table_base.title AS title, table_base.playtime AS playtime, table_album.album AS album, table_base.rating AS rating, table_base.comment AS comment, table_genre.genre AS genre FROM `table_base` LEFT JOIN table_interpret ON(table_base.interpretID = table_interpret.id) LEFT JOIN table_album ON(table_base.albumID = table_album.id) LEFT JOIN table_genre ON(table_base.genreID = table_genre.id) ORDER BY RAND() LIMIT $max"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { { $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpret)) ? $row->interpret : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : NULLSTR; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->album)) ? $row->album : NULLSTR; $subArray['r'] = (isset($row->rating)) ? $row->rating : NULLSTR; $subArray['c'] = (isset($row->comment)) ? $row->comment : NULLSTR; $result[] = $subArray; } } $queryResult->close(); } return $result; } function getRandomSong() { $result = array(); $simpleWhite = (true) ? NULLSTR : "WHERE rating == '~3~' OR rating == '~4~' OR rating == '~5~'"; $simpleBlack = (true) ? NULLSTR : "WHERE rating != '~1~' AND rating != '~2~'"; $query = "SELECT table_base.absolute AS absolute, table_interpret.interpret AS interpret, table_base.title AS title, table_base.playtime AS playtime, table_album.album AS album, table_base.rating AS rating, table_genre.genre AS genre FROM `table_base` LEFT JOIN table_interpret ON(table_base.interpretID = table_interpret.id) LEFT JOIN table_album ON(table_base.albumID = table_album.id) LEFT JOIN table_genre ON(table_base.genreID = table_genre.id) $simpleWhite $simpleBlack ORDER BY RAND() LIMIT 1"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); { $result['a'] = (isset($obj->absolute)) ? $obj->absolute : NULLSTR; $result['i'] = (isset($obj->interpret)) ? $obj->interpret : QUESTMARK; $result['t'] = (isset($obj->title)) ? $obj->title : NULLSTR; $result['p'] = (isset($obj->playtime)) ? $obj->playtime : NULLSTR; $result['l'] = (isset($obj->album)) ? $obj->album : NULLSTR; } $queryResult->close(); return $result; } function getTotalSongCount() { if (!$this->dbconnected) { return NULLINT; } else { $query = "SELECT MAX(`id`) AS `id` FROM `table_base`"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); return $obj->id; } } function getSongInfo($aSong, $aFirstHit = false) { $result = array(); if ($this->dbconnected) { $checkRef = ($aFirstHit) ? basename($aSong) : $aSong; $query = "SELECT * FROM `table_base` LEFT JOIN table_interpret ON(table_base.interpretID = table_interpret.id) LEFT JOIN table_album ON(table_base.albumID = table_album.id) LEFT JOIN table_genre ON(table_base.genreID = table_genre.id) WHERE `absolute` = '$checkRef'"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); $result['a'] = (isset($obj->absolute)) ? $obj->absolute : NULLSTR; $result['i'] = (isset($obj->interpret)) ? $obj->interpret : QUESTMARK; $result['t'] = (isset($obj->title)) ? $obj->title : NULLSTR; $result['p'] = (isset($obj->playtime)) ? $obj->playtime : NULLSTR; $result['l'] = (isset($obj->album)) ? $obj->album : NULLSTR; $result['g'] = (isset($obj->genre)) ? $obj->genre : NULLSTR; $result['y'] = (isset($obj->year)) ? $obj->year : NULLSTR; $result['d'] = (isset($obj->filedate)) ? $obj->filedate : NULLSTR; $result['r'] = (isset($obj->rating)) ? $obj->rating : NULLSTR; $result['rby'] = (isset($obj->ratingBy)) ? $obj->ratingBy : NULLSTR; $result['c'] = (isset($obj->comment)) ? $obj->comment : NULLSTR; $result['cby'] = (isset($obj->commentBy)) ? $obj->commentBy : NULLSTR; $queryResult->close(); } return $result; } function getVotedSongs($aOffset = 0, $aLimit = 0) { $result = array(); $limit = ($aLimit == 0) ? NULLSTR : ",$aLimit"; $query = "SELECT * FROM `table_base` LEFT JOIN table_interpret ON(table_base.interpretID = table_interpret.id) LEFT JOIN table_album ON(table_base.albumID = table_album.id) LEFT JOIN table_genre ON(table_base.genreID = table_genre.id) WHERE `rating` != '' OR `comment` != '' LIMIT $aOffset $limit"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpret)) ? $row->interpret : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : NULLSTR; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->album)) ? $row->album : NULLSTR; $subArray['g'] = (isset($row->genre)) ? $row->genre : NULLSTR; $subArray['y'] = (isset($row->year)) ? $row->year : NULLSTR; $subArray['d'] = (isset($row->filedate)) ? $row->filedate : NULLSTR; $subArray['r'] = (isset($row->rating)) ? $row->rating : NULLSTR; $subArray['rby'] = (isset($row->ratingBy)) ? $row->ratingBy : NULLSTR; $subArray['c'] = (isset($row->comment)) ? $row->comment : NULLSTR; $subArray['cby'] = (isset($row->commentBy)) ? $row->commentBy : NULLSTR; $result[] = $subArray; } $queryResult->close(); return $result; } function setSong($aSong) { $this->curSong = $aSong; } function setComment($aComment, $aBy = NULLSTR) { $result = false; $comment = trim($aComment); $query = "UPDATE `table_base` SET `comment` = '$comment', `commentBy` = '$aBy' WHERE `table_base`.`absolute` LIKE '%$this->curSong';"; $queryResult = $this->mySQL->query($query); if ($queryResult) { eventLog('CHANGED COMMENT: "'.$comment.'" for song: '.$this->curSong); $result = true; } return $result; } function setRating($aRating, $aBy = NULLSTR) { $result = false; $query = "UPDATE `table_base` SET `rating` = '$aRating', `ratingBy` = '$aBy' WHERE `table_base`.`absolute` LIKE '%$this->curSong';"; $queryResult = $this->mySQL->query($query); if ($queryResult) { eventLog('CHANGED RATING: "'.$aRating.'" for song: '.$this->curSong); $result = true; } return $result; } function saveFeedback() { return true; } function findSong($aSong) { if ($this->dbconnected) { $query = "SELECT `rating`,`ratingBy`,`comment`,`commentBy` FROM `table_base` WHERE `absolute` LIKE '%$aSong'"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); $this->curSongRating = (isset($obj->rating)) ? $obj->rating : NULLSTR; $this->curSongRatingBy = (isset($obj->ratingBy)) ? $obj->ratingBy : NULLSTR; $this->curSongComment = (isset($obj->comment)) ? $obj->comment : NULLSTR; $this->curSongCommentBy = (isset($obj->commentBy)) ? $obj->commentBy : NULLSTR; $queryResult->close(); } } function getComment() { return $this->curSongComment; } function getCommentBy() { return $this->curSongCommentBy; } function getRating() { return $this->curSongRating; } function getRatingBy() { return $this->curSongRatingBy; } function findSongReset() { $this->curSongComment = NULLSTR; $this->curSongCommentBy = NULLSTR; $this->curSongRating = NULLSTR; $this->curSongRatingBy = NULLSTR; } } 