<?php 
 require_once ('lib/utils.php'); class class_feedback { private string $depth; private string $feedbackXMLFile; private SimpleXMLElement $xml; private string $curSong; private mixed $curSongFound; private string $lastMsg; private string $curSongComment; private string $curSongCommentBy; private string $curSongRating; private string $curSongRatingBy; function __construct($aDepth = NULLSTR) { global $cfg_feedbackFile; $this->depth = $aDepth; $this->feedbackXMLFile = $this->depth . $cfg_feedbackFile; if (!file_exists($this->feedbackXMLFile)) { $this->_createNew($this->feedbackXMLFile); } $this->xml = simplexml_load_file($this->feedbackXMLFile); $this->curSong = NULLSTR; $this->curSongFound = false; $this->findSongReset(); $this->lastMsg = NULLSTR; } private function _createNew($aFile) { $newfile = fopen($aFile, 'w'); fwrite($newfile, '<?xml version="1.0" encoding="UTF-8"?>'.LFC.'<feedback></feedback>'); fclose($newfile); unset($newfile); } function getLastMsg() { return $this->lastMsg; } function getAllValued() { return count($this->xml->i); } function setSong($aSong) { $this->curSongFound = false; $this->curSong = $aSong; if ($this->xml) { $i = 0; foreach ($this->xml->i as $item) { if (strcmp(basename($item->a), basename($this->curSong)) == 0) { $this->curSongFound = $i; break; } $i++; } } } function setComment($aComment, $aBy = NULLSTR) { $result = false; { $attr = XML_BY; if ($this->curSongFound !== false) { $this->xml->i[$this->curSongFound]->c = htmlspecialchars( trim($aComment) ); $this->xml->i[$this->curSongFound]->c->attributes()->$attr = $aBy; eventLog('CHANGED COMMENT in feedback: "' . trim($aComment) . '" for song: ' . $this->curSong, $this->depth); $this->lastMsg = LNG_SUC_COMMENTED; $result = true; } else { $new = $this->xml->addchild('i'); $new->addchild('a', htmlspecialchars( $this->curSong )); $new->addchild('c', htmlspecialchars( trim($aComment) )); $new->c->addAttribute(XML_BY, $aBy); $new->addchild('r', NULLSTR); $new->r->addAttribute(XML_BY, NULLSTR); $this->curSongFound = true; eventLog('SET COMMENT in feedback: "' . trim($aComment) . '" for song: ' . $this->curSong, $this->depth); $this->lastMsg = LNG_SUC_COMMENTED; $result = true; } } return $result; } function setRating($aRating, $aBy = NULLSTR) { $result = false; $attr = XML_BY; if ($this->curSongFound !== false) { $this->xml->i[$this->curSongFound]->r = $aRating; $this->xml->i[$this->curSongFound]->r->attributes()->$attr = $aBy; eventLog('CHANGED RATING in feedback: "' . $aRating . '" for song: ' . $this->curSong, $this->depth); $this->lastMsg = LNG_SUC_RATED; $result = true; } else { $new = $this->xml->addchild('i'); $new->addchild('a', htmlspecialchars( $this->curSong )); $new->addchild('r', $aRating); $new->r->addAttribute(XML_BY, $aBy); $new->addchild('c', NULLSTR); $new->c->addAttribute(XML_BY, NULLSTR); $this->curSongFound = true; eventLog('SET RATING in feedback: "' . $aRating . '" for song: ' . $this->curSong, $this->depth); $this->lastMsg = LNG_SUC_RATED; $result = true; } return $result; } function saveFeedback() { $result = false; $handle = fopen($this->feedbackXMLFile, 'wb'); if (!fwrite($handle, $this->xml->asXML())) { $this->lastMsg = LNG_ERR_UNKNOWN; eventLog('ERROR in function saveFeedback() in file api_feedback.php'); } else { $result = true; } fclose($handle); if ($result && CFG_HUMAN_READABLE_FEEDBACK) { cntMakeHumanXML($this->feedbackXMLFile); } return $result; } function findSong($aSong) { $result = false; if ($this->xml) { $attr = XML_BY; foreach ($this->xml->i as $item) { if (strcmp($item->a, $aSong) == 0) { if (isset($item->c)) { $this->curSongComment = $item->c; $this->curSongCommentBy = $item->c->attributes()->$attr; } if (isset($item->r)) { $this->curSongRating = $item->r; $this->curSongRatingBy = $item->r->attributes()->$attr; } $result = true; break; } } } return $result; } function getComment() { return $this->curSongComment; } function getCommentBy() { return $this->curSongCommentBy; } function getRating() { return $this->curSongRating; } function getRatingBy() { return $this->curSongRatingBy; } function findSongReset() { $this->curSongComment = NULLSTR; $this->curSongCommentBy = NULLSTR; $this->curSongRating = NULLSTR; $this->curSongRatingBy = NULLSTR; } function getCount() { return $this->xml->count(); } } 