<?php 
 function cntPSS($aString) { $prep = str_replace('\'', '\'\\\'\'', $aString); return ' \'' . $prep . '\''; } function cntGetFileExt($aFilename) { $path_parts = pathinfo($aFilename); if (isset($path_parts['extension'])) return $path_parts['extension']; else return false; } function cntAsynchCommand($aCommand, $aPath = SLASH, $aCLI = true) { $result = false; $old = getcwd(); if (file_exists($aPath)) { chdir($aPath); $result = exec(CURDIR . $aCommand . ' > /dev/null &'); chdir($old); return (string)$result; } } function cntSubsituteCriticalJSChars($aString) { $result = str_replace('\'', '&acute;', $aString); return $result; } function cntMakeHumanXML($aXMLFile) { $result = false; $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->load($aXMLFile); if ($dom->save($aXMLFile)) $result = true; return $result; } function cntGetTimeDiffAsSecondsFromUnix($aTime) { return time() - $aTime; } function parseHumanMinSecStringToSeconds($aMinSecString, $asInt = false) { $time = explode(COLON, $aMinSecString); $min = (isset($time[0])) ? intval($time[0]) : '0'; $sec = (isset($time[1])) ? intval($time[1]) : '00'; if (!$asInt) return $min * 60 + $sec; else return intval($min * 60 + $sec); } function parseSecondsToHumanMinSecString($aSeconds) { $seconds = (integer)$aSeconds; $min = floor($seconds / 60); $sec = $seconds % 60; if ($min >= 0 && $sec >= 0) return $min . COLON . str_pad($sec, 2, 0, STR_PAD_LEFT); else return '-0:00'; } function cntDelTree($path, $aDirToo = false) { $result = false; $path = rtrim($path, SLASH).SLASH; $handle = opendir($path); if (is_dir($path)) { while(false !== ($file = readdir($handle))) { if($file != DOT and $file != DDOT ) { $fullpath = $path.$file; if(is_dir($fullpath)) cntDelTree($fullpath, $aDirToo); else unlink($fullpath); } } closedir($handle); if ($aDirToo) $result = rmdir($path); else $result = true; } return $result; } function cntFilecount($aFolderPath) { $filescount = 0; $dir = opendir($aFolderPath); if (!$dir){return 0;} while (($file = readdir($dir)) !== false) { if ($file[0] == DOT) continue; if (is_dir($aFolderPath.$file)) { $filescount += cntFilecount($aFolderPath.$file.DIRECTORY_SEPARATOR); } else { $filescount++; } } closedir($dir); return $filescount; } function cntIsMobile() { global $cfg_timeZone; $timeZone = (isset($cfg_timeZone)) ? $cfg_timeZone : 'UTC'; date_default_timezone_set($timeZone); $sapi_type = php_sapi_name(); if (strtolower(substr($sapi_type, 0, 3)) != 'cli') { if (!isset($_SESSION)) session_start(); if (isset($_SESSION['forceIsMobile'])) { return $_SESSION['forceIsMobile']; } else { $useragent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null; return $useragent && (preg_match('/android|avantgo|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|e\-|e\/|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(di|rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sandroid, iphone, handybrowser, mobilbrowser, mobil, handy, iemobile, symbiana(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|xda(\-|2|g)|yas\-|your|zeto|zte\-/i', substr($useragent, 0, 4))); } } } function cntIsConsole() { $useragent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null; return $useragent && (preg_match('/android|lynx|m1\-w|m3ga|zte\-/i', substr($useragent, 0, 4))); } function cntStdMsg ($aMessage) { if ($aMessage != NULLSTR) return '<span id="StdMsg">'.$aMessage.'</span>'; } function cntOkMsg ($aMessage) { if ($aMessage != NULLSTR) return '<span id="okMsg">'.$aMessage.'</span>'; } function cntErrMsg($aMessage) { if ($aMessage != NULLSTR) return '<span id="errorMsg">'.$aMessage.'</span>'; } function cntMBL($aLink) { return '['. $aLink .']'; } function cntTrim($aStr) { $cutBlank = (isset($_COOKIE['bool_cutBlank'])) ? $_COOKIE['bool_cutBlank'] : YES; if ($cutBlank == YES) return trim($aStr); else return $aStr; } function util_coverStringsInApostrophes($strings) { if (trim($strings) == NULLSTR) return NULLSTR; $tmp1 = explode(COMMA, $strings); $tmp2 = "'".implode("','",$tmp1)."'"; return str_replace(",' " , ",'", $tmp2); } function util_coverArrayItemsInApostrophes($array) { if (empty($array)) return NULLSTR; $tmp2 = "'".implode("','",$array)."'"; return $tmp2; } function cntLog($aEvent, $aDepth = NULLSTR) { global $cfg_logFile; if ($cfg_logFile !== false) { $time = date('Y-m-d H:i:s'); $loc = (isset($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : 'unknown/CLIscript'; $causer = (isset($_SESSION['str_nickname']) && $_SESSION['str_nickname'] != NULLSTR) ? $_SESSION['str_nickname'] : QUESTMARK; $logEntry = $time . SEMICOLON . $loc . SEMICOLON . $causer . SEMICOLON . $aEvent . LFC; if (!file_exists($aDepth . $cfg_logFile)) file_put_contents($aDepth . $cfg_logFile, $logEntry); else { $tmp = file_get_contents($aDepth . $cfg_logFile, false, NULL, 0, 100000) . $logEntry; file_put_contents($aDepth . $cfg_logFile, $tmp); } } return $aEvent; } function moveElementInArray($array, $toMove, $targetIndex) { if (is_int($toMove)) { $tmp = array_splice($array, $toMove, 1); array_splice($array, $targetIndex, 0, $tmp); $output = $array; } elseif (is_string($toMove)) { $indexToMove = array_search($toMove, array_keys($array)); $itemToMove = $array[$toMove]; array_splice($array, $indexToMove, 1); $i = 0; $output = Array(); foreach($array as $key => $item) { if ($i == $targetIndex) { $output[$toMove] = $itemToMove; } $output[$key] = $item; $i++; } } return $output; } function cntGradientFromTo($aFromCol, $aToCol, $aGraduations = 10) { if (empty($aGraduations) || $aGraduations < 2) { $aGraduations = 2; } $aGraduations--; $RedOrigin = hexdec(substr($aFromCol, 0, 2)); $GrnOrigin = hexdec(substr($aFromCol, 2, 2)); $BluOrigin = hexdec(substr($aFromCol, 4, 2)); $GradientSizeRed = (hexdec(substr($aToCol, 0, 2)) - $RedOrigin) / $aGraduations; $GradientSizeGrn = (hexdec(substr($aToCol, 2, 2)) - $GrnOrigin) / $aGraduations; $GradientSizeBlu = (hexdec(substr($aToCol, 4, 2)) - $BluOrigin) / $aGraduations; $RetVal = array(); for($i=0; $i <= $aGraduations; $i++) { $RetVal[$i] = str_pad(dechex($RedOrigin + ($GradientSizeRed * $i)), 2, '0', STR_PAD_LEFT) . str_pad(dechex($GrnOrigin + ($GradientSizeGrn * $i)), 2, '0', STR_PAD_LEFT) . str_pad(dechex($BluOrigin + ($GradientSizeBlu * $i)), 2, '0', STR_PAD_LEFT); } return $RetVal; } function cntGetHumanRating($aRating) { $result = NULLSTR; if (strpos($aRating, RATE1) !== false) $result = str_replace(RATE1, RATE1_HUMAN, $aRating); elseif (strpos($aRating, RATE2) !== false) $result = str_replace(RATE2, RATE2_HUMAN, $aRating); elseif (strpos($aRating, RATE3) !== false) $result = str_replace(RATE3, RATE3_HUMAN, $aRating); elseif (strpos($aRating, RATE4) !== false) $result = str_replace(RATE4, RATE4_HUMAN, $aRating); elseif (strpos($aRating, RATE5) !== false) $result = str_replace(RATE5, RATE5_HUMAN, $aRating); return $result; } function cntGetEmojiRating($rating) { switch ($rating) { case RATE1: return RATE1_DINGBAT; break; case RATE2: return RATE2_DINGBAT; break; case RATE3: return RATE3_DINGBAT; break; case RATE4: return RATE4_DINGBAT; break; case RATE5: return RATE5_DINGBAT; break; } } function cntGetPreviousDir($aCurDir, $aHandleLastSlash = true) { if ($aHandleLastSlash) { $length = strlen($aCurDir); if (substr($aCurDir, $length - 1, 1) == SLASH) $aCurDir = substr($aCurDir, 0, $length - 1); } $tmp = explode(SLASH, $aCurDir); array_pop($tmp); return implode(SLASH, $tmp); } function cntGetAlbumPicURL($aSong, $aAlbum, $aSmallDummy = false, $negativeResultAsBool = false) { global $cfg_absPathToSongs; global $cfg_musicFileType; global $cfg_pictureFileType; $nickname = (isset($_SESSION['str_nickname'])) ? $_SESSION['str_nickname'] : NULLSTR; $pathToSong = dirname($aSong) . SLASH; $cover = $pathToSong . basename($aSong, DOT . $cfg_musicFileType) . DOT . $cfg_pictureFileType; if (file_exists($cfg_absPathToSongs . $cover)) { $cover = str_replace('&', '%26', $cover); $picLink = 'lib/picDisp.php?pic='.$cover.'&hash='.md5($nickname); } else { $cover = $pathToSong . $aAlbum . DOT . $cfg_pictureFileType; if (file_exists($cfg_absPathToSongs . $cover)) { $cover = str_replace('&', '%26', $cover); $picLink = 'lib/picDisp.php?pic='.$cover.'&hash='.md5($nickname); } else { $cover = $pathToSong . basename(cntGetPreviousDir($aSong)) . DOT . $cfg_pictureFileType; if (file_exists($cfg_absPathToSongs . $cover)) { $cover = str_replace('&', '%26', $cover); $picLink = 'lib/picDisp.php?pic='.$cover.'&hash='.md5($nickname); } else { if ($negativeResultAsBool) return false; $darkMode = (isset($_COOKIE['bool_darkMode']) && $_COOKIE['bool_darkMode'] == YES) ? true : false; if ($aSmallDummy) { $picLink = (!$darkMode) ? 'res/piMoo_logo.png' : 'res/piMoo_logoDark.png'; } else { $picLink = (!$darkMode) ? 'res/piMoo_bg.png' : 'res/piMoo_bgDark.png'; } } } } return $picLink; } function cntGetDriveUsageInPercent($aDriveORPath) { if (is_dir($aDriveORPath)) { $diskTotalSpace = disk_total_space ($aDriveORPath); return ($diskTotalSpace > 0) ? intval((100 - (disk_free_space ($aDriveORPath) * 100 / $diskTotalSpace))) : 100; } else { echo 'Not a drive or directory in cntGetDriveUsageInPercent: "' . $aDriveORPath . '"'; return 100; } } function cntGetServerMemoryUsage() { $free = shell_exec('free'); $free = (string)trim($free); $free_arr = explode(LFC, $free); $mem = explode(BLANK, $free_arr[1]); $mem = array_filter($mem); $mem = array_merge($mem); $memory_usage = $mem[2]/$mem[1]*100; return $memory_usage; } function cntGetServerCPU_usage() { $load = sys_getloadavg(); return $load[0]; } function cntGetCPU_temperature() { $temp = intval( exec('cat /sys/class/thermal/thermal_zone0/temp') ); $raspiCurCPUTemp = round ($temp / 1000 ); return ($raspiCurCPUTemp * RASPI_CPU_MAX_TEMP) / RASPI_CPU_MAX_TEMP; } function util_systemShutdown($depth = NULLSTR) { global $cfg_isDocker; global $cfg_dockerHostPipeShutdown; $result = 'try to shutdown the system with: '; if ($cfg_isDocker !== true) { $cmd = 'sudo /sbin/shutdown -h now'; $result .= $cmd.LFH; } if ($cfg_isDocker === true) { $timestamp = date("Y-m-d H:i:s"); file_put_contents($cfg_dockerHostPipeShutdown, $timestamp); $cmd = "echo '$timestamp' > $cfg_dockerHostPipeShutdown"; $result .= $cmd.LFH; } cntLog($result, $depth); $result .= (string)system($cmd); return $result; } function cntCreateJSONheader() { header('Cache-Control: no-cache, must-revalidate'); header('Content-type: application/json'); } function cntCreateCORSheader() { $http_origin = (isset($_SERVER['HTTP_ORIGIN'])) ? $_SERVER['HTTP_ORIGIN'] : '*'; header('Access-Control-Allow-Origin: '.$http_origin); header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept'); header('Access-Control-Allow-Credentials: true'); } function getPLRI() { global $cfg_playlistRefreshInterval; return (string)intval($cfg_playlistRefreshInterval * 1000); } function getSecondsPerMinSec($aTime) { $time = str_pad($aTime, 4 ,'0', STR_PAD_LEFT); $sec = intval(substr($time, 2)); $min = intval(substr($time, 0,2)); return ($sec + $min * 60); } function writeMP3TagsToMediabase($aFile) { global $cfg_absPathToSongs; global $cfg_musicFileType; global $mediaBase; global $myFeedback; $getID3 = new getID3; $ThisFileInfo = $getID3->analyze($aFile); getid3_lib::CopyTagsToComments($ThisFileInfo); $curFile = str_replace($cfg_absPathToSongs, NULLSTR, $aFile); if (isset($ThisFileInfo['comments_html']['artist'][0])) $interpret = htmlspecialchars_decode(utf8_encode($ThisFileInfo['comments_html']['artist'][0])); else $interpret = QUESTMARK; $mediaBase->startElement(XML_STRDITEM); $mediaBase->startElement('a'); $mediaBase->text(htmlspecialchars_decode($curFile)); $mediaBase->endElement(); $mediaBase->startElement('i'); $mediaBase->text($interpret); $mediaBase->endElement(); $mediaBase->startElement('t'); if (isset($ThisFileInfo['comments_html']['title'][0])) $mediaBase->text(htmlspecialchars_decode(utf8_encode($ThisFileInfo['comments_html']['title'][0]))); else $mediaBase->text( basename($aFile, DOT.$cfg_musicFileType)); $mediaBase->endElement(); $mediaBase->startElement('l'); if (isset($ThisFileInfo['id3v2']['album'])) $mediaBase->text(htmlspecialchars_decode (utf8_encode($ThisFileInfo['id3v2']['album']))); elseif (isset($ThisFileInfo['id3v1']['album'])) $mediaBase->text( htmlspecialchars_decode (utf8_encode($ThisFileInfo['id3v1']['album']))); $mediaBase->endElement(); $mediaBase->startElement('p'); if (isset($ThisFileInfo['playtime_string'])) $mediaBase->text($ThisFileInfo['playtime_string']); $mediaBase->endElement(); $mediaBase->startElement('g'); if (isset($ThisFileInfo['comments_html']['genre'][0])) $mediaBase->text( htmlspecialchars_decode (utf8_encode($ThisFileInfo['comments_html']['genre'][0]))); $mediaBase->endElement(); $mediaBase->startElement('y'); @$year = $ThisFileInfo['id3v2']['year']; if (empty($year)) @$year = $ThisFileInfo['id3v1']['year']; $mediaBase->text($year); $mediaBase->endElement(); $mediaBase->startElement('d'); if (isset($ThisFileInfo['filenamepath'])) $mediaBase->text(date('Y-m-d', filemtime($ThisFileInfo['filenamepath']))); $mediaBase->endElement(); $myFeedback->findSong(basename($aFile)); $mediaBase->startElement('r'); $mediaBase->startAttribute(XML_BY); $mediaBase->text($myFeedback->getRatingBy()); $mediaBase->endAttribute(); $mediaBase->text($myFeedback->getRating()); $mediaBase->endElement(); $mediaBase->startElement('c'); $mediaBase->startAttribute(XML_BY); $mediaBase->text($myFeedback->getCommentBy()); $mediaBase->endAttribute(); $mediaBase->text($myFeedback->getComment()); $mediaBase->endElement(); $myFeedback->findSongReset(); $mediaBase->endElement(); unset($getID3); } function recursive_writeMP3TagsToMediabase($path, $html) { global $mediaBase; global $cfg_musicFileType; global $progBar; $LF = ($html) ? LFH : LFC; $handle = opendir($path); while ($file = readdir($handle)) { if ($file != DOT && $file != DDOT && substr($file, 0, 1) != DOT) { if (is_dir($path.$file)) { recursive_writeMP3TagsToMediabase($path.$file.SLASH, $html); } else { if ($cfg_musicFileType == strtolower(cntGetFileExt($file))) { echo $file.$LF; writeMP3TagsToMediabase($path.$file); } if ($html) $progBar->step(); } } } closedir($handle); } function updateMP3TagsToMediabase($aFile) { global $cfg_absPathToSongs; global $cfg_musicFileType; global $mediaBaseUpdate; $curFile = str_replace($cfg_absPathToSongs, NULLSTR, $aFile); $newItem = $mediaBaseUpdate->addChild(XML_STRDITEM); $getID3 = new getID3; $ThisFileInfo = $getID3->analyze($aFile); getid3_lib::CopyTagsToComments($ThisFileInfo); if (isset($ThisFileInfo['comments_html']['artist'][0])) $interpret = htmlspecialchars_decode(utf8_encode($ThisFileInfo['comments_html']['artist'][0])); else $interpret = QUESTMARK; $newItem->addChild('a', htmlspecialchars_decode( $curFile )); $newItem->addChild('i', $interpret); if (isset($ThisFileInfo['comments_html']['title'][0])) $newItem->addChild('t', htmlspecialchars_decode ( utf8_encode( $ThisFileInfo['comments_html']['title'][0]) )); else $newItem->addChild('t', basename( $aFile, $cfg_musicFileType)); if (isset($ThisFileInfo['id3v2']['album'])) $newItem->addChild('l', htmlspecialchars_decode ( utf8_encode( $ThisFileInfo['id3v2']['album'] ) )); elseif (isset($ThisFileInfo['id3v1']['album'])) $newItem->addChild('l', htmlspecialchars_decode ( utf8_encode( $ThisFileInfo['id3v1']['album'] ) )); if (isset($ThisFileInfo['playtime_string'])) $newItem->addChild('p', $ThisFileInfo['playtime_string']); if (isset($ThisFileInfo['comments_html']['genre'][0])) $newItem->addChild('g', htmlspecialchars_decode(utf8_encode( $ThisFileInfo['comments_html']['genre'][0]))); @$year = $ThisFileInfo['id3v2']['year']; if (empty($year)) @$year = $ThisFileInfo['id3v1']['year']; $newItem->addChild('y', $year); if (isset($ThisFileInfo['filenamepath'])) $newItem->addChild('d', date('Y-m-d', filemtime($ThisFileInfo['filenamepath']))); $newItem->addChild('r'); $newItem->addChild('c'); unset($getID3); } function recursive_updateMP3TagsToMediabase($path, $updateDaysUnix, $html) { global $mediaBaseUpdate; global $cfg_musicFileType; global $mediaBaseUpdateStr; global $progBar; $LF = ($html) ? LFH : LFC; $handle = opendir($path); while ($file = readdir($handle)) { if ($file != DOT && $file != DDOT && substr($file, 0, 1) != DOT) { if (is_dir($path . $file)) { recursive_updateMP3TagsToMediabase($path.$file.SLASH, $updateDaysUnix, $html); } else { if ($cfg_musicFileType == strtolower(cntGetFileExt($file))) { if (filectime($path.$file) >= $updateDaysUnix) { echo 'found - check if not exists: '.$file.$LF; if (strpos($mediaBaseUpdateStr, $file) === false) { if ($html) { echo '<span style="color: red;">not existing - adding now: '.$file.'</span>'.$LF; $progBar->step(); } else { echo 'not existing - adding now: '.$file.$LF; } updateMP3TagsToMediabase($path.$file); } } } } } } closedir($handle); } function createShadowConfig($depth = NULLSTR, $allowMultiNickname, $allowMultiblePlaylistEntries, $partyMode, $genreWhitelist, $caching) { global $cfg_configShadow; $content = '<?php $cfg_allowMultiNickname='.$allowMultiNickname.'; $cfg_allowMultiblePlaylistEntries='.$allowMultiblePlaylistEntries.'; $cfg_cache='.$caching.'; $cfg_partyMode='.$partyMode.'; $cfg_genreWhitelist=array('.$genreWhitelist.'); '; file_put_contents($depth.$cfg_configShadow, $content); } require 'class_nickname.php'; function _init() { global $cfg_maxSearchResultsPerPage; global $cfg_nonMobileMultiplier; if (!cntIsMobile()) $cfg_maxSearchResultsPerPage = $cfg_maxSearchResultsPerPage * $cfg_nonMobileMultiplier; global $cfg_playlistRefreshInterval; $cfg_playlistRefreshInterval = ($cfg_playlistRefreshInterval >= 1) ? $cfg_playlistRefreshInterval : 1; global $cfg_minimumSearchChars; $cfg_minimumSearchChars = ($cfg_minimumSearchChars >= 1) ? $cfg_minimumSearchChars : 1; } _init(); 