<?php 
 class class_nickname { function __construct($aDepth = NULLSTR) { global $cfg_tmpPath; global $cfg_allowMultiNickname; $this->depth = $aDepth; $this->allowMultiNickname = $cfg_allowMultiNickname; $this->nicknamePath = $this->depth . $cfg_tmpPath . 'nicknames/'; if (!is_dir($this->nicknamePath)) mkdir($this->nicknamePath); $this->clientIP = (isset($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : QUESTMARK; $this->lastDetectedNickIP = NULLSTR; $this->nickname = NULLSTR; } private function _isValid($aNickname) { if ( $aNickname != '::1' && strtolower($aNickname) != 'localhost' && $aNickname != '127.0.0.1' && $aNickname != NICK_AUTO && $aNickname != NICK_TRIGGER && trim ($aNickname) != NULLSTR ) { return true; } else { return false; } } private function _isFree($aNickname) { $check = scandir($this->nicknamePath); $nickIP = (file_exists($this->nicknamePath . $aNickname)) ? file_get_contents($this->nicknamePath . $aNickname) : false; $this->lastDetectedNickIP = $nickIP; if ( $this->allowMultiNickname || !in_array($aNickname, $check) || ($this->clientIP === $nickIP) || (isset($_SESSION['str_nickname']) && $_SESSION['str_nickname'] == $aNickname) ) { return true; } else { return false; } } function getNickname() { return $this->nickname; } function push($aNickname, $aCurrent = NULLSTR) { $result = false; if (!$this->_isValid($aNickname)) { cntLog(LNG_NICK_NOT_VALID . COLON . BLANK . $aNickname, $this->depth); } else { if (!$this->_isFree($aNickname)) { cntLog(LNG_NICK_ALREADY_USED.COLON.BLANK.$aNickname.', on IP: '.$this->lastDetectedNickIP, $this->depth); } else { if ($aCurrent != NULLSTR) $this->dropForeign($aCurrent); if (!isset($_SESSION)) session_start(); $_SESSION['str_nickname'] = $aNickname; $this->nickname = $aNickname; file_put_contents($this->nicknamePath . $aNickname, $this->clientIP); cntLog('set nickname: ' . $aNickname . ' (old: ' . $aCurrent . ')', $this->depth); $result = true; } } return $result; } function dropForeign($aNickname, $aDepth = NULLSTR) { $result = false; if (file_exists($this->nicknamePath . $aNickname) && !is_dir($this->nicknamePath . $aNickname)) { if (unlink($this->nicknamePath . $aNickname)) $result = true; else cntLog('failed to unlink hook from filesystem while loggin out: ' . $aNickname, $this->depth); } else cntLog('logged out: ' . $aNickname . ' (but nickname hook in filesystem was not available)', $this->depth); return $result; } function drop($nickname) { $result = false; session_unset(); if (!session_destroy()) { cntLog('failed to destroy session while loggin out: '.$nickname, $this->depth); } else { if (!file_exists($this->nicknamePath.$nickname) || is_dir($this->nicknamePath.$nickname)) { cntLog('logged out: '.$nickname.' (but nickname hook in filesystem was not available)', $this->depth); $result = true; } else { if (!unlink($this->nicknamePath.$nickname)) { cntLog('failed to unlink hook from filesystem while loggin out: '.$nickname, $this->depth); } else { cntLog('logged out: ' .$nickname, $this->depth); $result = true; } } } return $result; } static function showCurrentNicknames($depth = NULLSTR) { global $cfg_tmpPath; $output = NULLSTR; $nicknames = $depth.$cfg_tmpPath.DIR_NICKNAMES; if (is_dir($nicknames)) { $files = scandir($nicknames); if (count($files) > 2) { $output .= '<div class="takenNicknameArea centerAlignedBlock">'; $output .= '<div style="margin: 0em 0em 1em 1em; font-style: italic;">'.LNG_TAKEN_NICKNAMES.'</div>'; foreach($files as $nicks) { if (substr($nicks, 0, 1) != DOT) { $output .= '<div id="nickID'.$nicks.'" class="takenNicknames">'.cntMBL('<a class="linkNice" href="javascript:promptNickname(\''.$nicks.'\', 200)">'.$nicks.'</a>').'</div>'; } } $output .= '</div>'; } } return $output; } } 