<?php 
 require_once('defines.inc.php'); require_once('lib/utils.php'); require('api_playerInterface.php'); class class_player implements interface_player { private $lastMsg = NULLSTR; function __construct($aDepth = NULLSTR) { global $cfg_playerStateFile; global $cfg_system; global $cfg_volStep; $this->depth = $aDepth; $this->playerStateFile = $this->depth . $cfg_playerStateFile; $this->system = $cfg_system; $this->volStep = $cfg_volStep; $this->fc = 7; $this->gpioHasBeenInit = false; } private function setLastMsg($lastMsg) { $this->lastMsg = $lastMsg; } public function getLastMsg() { return $this->lastMsg; } private function _setPlayerState($aState) { file_put_contents($this->playerStateFile, $aState); } function getPlayerParam($aPath, $aKeep = false) { global $cfg_playerParamFile; $result = NULLSTR; if (!file_exists($aPath.$cfg_playerParamFile)) { } else { $param = file_get_contents($aPath.$cfg_playerParamFile); $result = BLANK . trim($param, " \n") . BLANK; if (!$aKeep) file_put_contents($aPath.$cfg_playerParamFile, NULLSTR); } return $result; } function pushPlayerParam($aParam) { global $cfg_playerParamFile; $result = file_put_contents($this->depth.$cfg_playerParamFile, $aParam); return $result; } function getPlayerState() { if (file_exists($this->playerStateFile)) return trim(file_get_contents($this->playerStateFile)); else return PS_UNKNOWN; } static function static_getPlayerState($aDepth = NULLSTR) { global $cfg_playerStateFile; if (file_exists($aDepth.$cfg_playerStateFile)) return trim(file_get_contents($aDepth.$cfg_playerStateFile)); else return PS_UNKNOWN; } static function static_getRemainTimeInSeconds($depth = NULLSTR) { global $cfg_playerRemainTime_abs; $result = false; if (file_exists($depth.$cfg_playerRemainTime_abs)) { $result = trim(file_get_contents($depth.$cfg_playerRemainTime_abs)); } return $result; } static function static_updateRemainTimeInSeconds($seconds, $depth = NULLSTR) { global $cfg_playerRemainTime_abs; $result = false; if (file_exists($depth.$cfg_playerRemainTime_abs)) { $result = file_put_contents($depth.$cfg_playerRemainTime_abs, $seconds); } return $result; } private function _fadeVolDown($aSleepTime = 30000) { global $cfg_alsacontrol; for ($i = $this->fc; $i > 0; $i--) { if ($this->system == RASPIAN) exec("amixer set $cfg_alsacontrol".BLANK.(string)($this->volStep * 100) . '-'); if ($this->system == DEBIAN) exec("amixer -c 0 set $cfg_alsacontrol".BLANK.(string)$this->volStep.'dB-'); usleep($aSleepTime); } } private function _fadeVolUp($aSleepTime = 10000) { global $cfg_alsacontrol; for ($i = 0; $i <= $this->fc; $i++) { if ($this->system == RASPIAN) exec("amixer set $cfg_alsacontrol".BLANK.(string)($this->volStep * 100) . '+'); if ($this->system == DEBIAN) exec("amixer -c 0 set $cfg_alsacontrol".BLANK.(string)$this->volStep.'dB+'); usleep($aSleepTime); } } function cmdTurnOn() { if ($this->getPlayerState() == PS_OFF OR $this->getPlayerState() == PS_UNKNOWN) { $this->_setPlayerState(PS_PLAYING); return cntAsynchCommand('/etc/init.d/piMood run'); } } function cmdTurnOff() { $this->_setPlayerState(PS_OFF); $result = NULLSTR; $this->_fadeVolDown(250000); $result .= cntAsynchCommand('/etc/init.d/piMood break'); sleep(1); $this->_fadeVolUp(1000); return $result; } function cmdNext($aVolNoTouch = false) { global $cfg_playerProc; $result = false; if ( $this->getPlayerState() == PS_UNKNOWN || $this->getPlayerState() == PS_OFF ) { $this->setLastMsg(LNG_PLAYER_MUST_BE_RUNNING); } else { if (!$aVolNoTouch) $volDown = true; else $volDown = false; if ($this->getPlayerState() == PS_PAUSED) { $volDown = false; $this->cmdPlay(false); usleep(10000); } if ($this->getPlayerState() != PS_PAUSED) { if ($volDown) $this->_fadeVolDown(250000); exec("pkill -USR1 -x $cfg_playerProc"); if ($this->system == RASPIAN) { sleep(1); } if ($this->system == DEBIAN) { usleep(500000); } if (!$aVolNoTouch) $this->_fadeVolUp(100000); $result = true; } } return $result; } function cmdVolumeUp() { global $cfg_alsacontrol; $msg = NULLSTR; if ($this->system == RASPIAN) $msg .= (string)exec("amixer set $cfg_alsacontrol".BLANK.(string)($this->volStep * 100) . '+'); if ($this->system == DEBIAN) $msg .= (string)exec("amixer -c 0 set $cfg_alsacontrol".BLANK.(string)$this->volStep.'dB+'); return $msg; } function cmdVolumeDown() { global $cfg_alsacontrol; $msg = NULLSTR; if ($this->system == RASPIAN) $msg .= (string)exec("amixer set $cfg_alsacontrol".BLANK.(string)($this->volStep * 100) . '-'); if ($this->system == DEBIAN) $msg .= (string)exec("amixer -c 0 set $cfg_alsacontrol".BLANK.(string)$this->volStep.'dB-'); return $msg; } function cmdPause() { global $cfg_playerProc; $result = false; if ($this->getPlayerState() != PS_PAUSED) { $this->_setPlayerState(PS_PAUSED); $this->_fadeVolDown(); exec ("pkill -STOP -x $cfg_playerProc"); exec ('pkill -STOP -x cli_common.php'); usleep(500000); $result = true; } return $result; } function cmdPlay($volUp = true) { global $cfg_playerProc; $result = false; if ($this->getPlayerState() != PS_PLAYING) { $this->_setPlayerState(PS_PLAYING); exec("pkill -CONT -x $cfg_playerProc"); exec('pkill -CONT -x cli_common.php'); if ($volUp) $this->_fadeVolUp(); $result = true; } return $result; } private function cmdSkip($aSkipSeconds) { global $cfg_playerExec; global $cfg_playerRemainTime; $result = false; if ($this->getPlayerState() != PS_PLAYING) $this->setLastMsg(LNG_SKIP_ONLY_ON_PLAY); else { if (!file_exists($this->depth . $cfg_playerRemainTime)) { cntLog('failed to load current remaintime from remainTimePipe', $this->depth); $this->setLastMsg(LNG_ERR_UNKNOWN_FUNNY); } else { require_once 'keep/config.php'; require_once 'api_playlist.php'; $myPlaylist = new class_playlist($this->depth); $onAirSong = $myPlaylist->getWholePlaylist(true); if (isset($onAirSong)) { $playTime = parseHumanMinSecStringToSeconds($onAirSong[0]['p']); $remainTime = file_get_contents($this->depth . $cfg_playerRemainTime); $currentTime = $playTime - $remainTime; $newTime = $currentTime + $aSkipSeconds; if ( $newTime < 5 || $newTime >= $playTime - 5) { $this->setLastMsg(LNG_SKIP_TIME_TO_SHORT); } else { $newRemainTime = $playTime - $newTime; $newFrame = floor( $newTime * FRAMES_PER_SEC ); $myPlaylist->duplicateOnAirInCue(); if ($this->pushPlayerParam('--skip ' . $newFrame)) { usleep(100000); $this->cmdNext(true); usleep(100000); if ($myPlaylist->pushPlayerRemainTime($newRemainTime)) $result = true; } } } } } return $result; } function cmdRewind($aSkipSeconds = -30) { $this->cmdSkip($aSkipSeconds); } function cmdForward($aSkipSeconds = 30) { $this->cmdSkip($aSkipSeconds); } function GPIO_ON() { global $cfg_isDocker; global $cfg_GPIO_HiFi; global $cfg_GPIO_high; $result = NULLSTR; if ($this->system == RASPIAN && $cfg_GPIO_HiFi != OFF) { if ($cfg_isDocker === true) { if (!$this->gpioHasBeenInit) { $result .= (string)shell_exec("echo $cfg_GPIO_HiFi > /sys/class/gpio/export"); $this->gpioHasBeenInit = true; } $result .= (string)shell_exec("echo out > /sys/class/gpio/gpio$cfg_GPIO_HiFi/direction"); } else { $result .= (string)shell_exec("pigs w $cfg_GPIO_HiFi $cfg_GPIO_high"); } } cntLog('class_player::GPIO_ON() result: ' . $result, $this->depth); return $result; } function GPIO_OFF() { global $cfg_isDocker; global $cfg_GPIO_HiFi; global $cfg_GPIO_low; $result = NULLSTR; if ($this->system == RASPIAN && $cfg_GPIO_HiFi != OFF) { if ($cfg_isDocker === true) { $cfg_GPIO_low = '1'; $result .= (string)shell_exec("echo $cfg_GPIO_low > /sys/class/gpio/gpio$cfg_GPIO_HiFi/value"); } else { $result .= (string)shell_exec("pigs w $cfg_GPIO_HiFi $cfg_GPIO_low"); } } cntLog('class_player::GPIO_OFF() result: ' . $result, $this->depth); return $result; } } 