<?php 
 class class_mediaBase implements interface_mediabase { function __construct($aDepth = NULLSTR) { global $cfg_mediabaseFile; global $cfg_genreWhitelist; global $cfg_genreBlacklist; $this->depth = $aDepth; $this->mediabaseFile = $this->depth . $cfg_mediabaseFile; if (file_exists($this->mediabaseFile)) { $this->mediaBaseXML = simplexml_load_file($this->mediabaseFile); } else { echo ('<span style="color: red;">' . $this->mediabaseFile . ' is not available, please import your songs with the <span style="color: blue; font-weight: bold;">blue button</span>...</span>'); } $this->curSong = NULLSTR; $this->curSongFound = false; $this->findSongReset(); $this->genreWhitelist = $cfg_genreWhitelist; $this->genreWhitelistActive = (count($this->genreWhitelist) > 0 && trim($this->genreWhitelist[0]) != NULLSTR); $this->genreBlacklist = $cfg_genreBlacklist; $this->lastMsg = NULLSTR; } function getLastMsg() { return $this->lastMsg; } function getSearchResult($aSeachStr, $aOffset = 0, $aLimit = 0, $aDL_level = false, $aCaseSensitive = false) { global $cfg_minimumSearchChars; $limitCount = $aOffset; $refCounter = 0; $result = array(); if (strlen($aSeachStr) >= $cfg_minimumSearchChars) { if ($this->mediaBaseXML) { $attr = XML_BY; foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; $songHulk = ($item->i) . BLANK . ($item->t) . BLANK . ($item->l) . BLANK . ($item->g) . BLANK . ($item->y) . BLANK . ($item->r) . BLANK . ($item->r->attributes()->$attr) . BLANK . ($item->c) . BLANK . ($item->c->attributes()->$attr); $songHulkDecoded = html_entity_decode($songHulk, ENT_QUOTES | ENT_IGNORE, 'UTF-8'); $caseSensitive = ($aCaseSensitive) ? NULLINT : FNM_CASEFOLD; $check = (fnmatch('*' . cntTrim($aSeachStr) . '*', $songHulkDecoded, $caseSensitive)); if ($aDL_level > 0) { $DL_in = levenshtein($aSeachStr, html_entity_decode($item->i, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); $DL_ti = levenshtein($aSeachStr, html_entity_decode($item->t, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); $DL_al = levenshtein($aSeachStr, html_entity_decode($item->l, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); $DL_ge = levenshtein($aSeachStr, html_entity_decode($item->g, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); if ($DL_in <= $aDL_level || $DL_ti <= $aDL_level || $DL_al <= $aDL_level || $DL_ge <= $aDL_level) $check = true; } if ($check !== false) { $refCounter++; if ($refCounter <= $aOffset) continue; if ( (in_array($item->g, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($item->g, $this->genreBlacklist) ) { $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['r'] = $item->r; $result[] = $subArray; } $limitCount++; } } } } return $result; } function getSearchResultByUser($aUser, $aOffset = 0, $aLimit = 0, $aCaseSensitive = false) { global $cfg_minimumSearchChars; $limitCount = $aOffset; $refCounter = 0; $result = array(); if (strlen($aUser) >= $cfg_minimumSearchChars) { if ($this->mediaBaseXML) { $attr = XML_BY; foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; $songHulk = ($item->r->attributes()->$attr) . BLANK . ($item->c->attributes()->$attr); $songHulkDecoded = html_entity_decode($songHulk, ENT_QUOTES | ENT_IGNORE, 'UTF-8'); $caseSensitive = ($aCaseSensitive) ? NULLINT : FNM_CASEFOLD; $check = (fnmatch('*' . cntTrim($aUser) . '*', $songHulkDecoded, $caseSensitive)); if ($check !== false) { $refCounter++; if ($refCounter <= $aOffset) continue; if ( (in_array($item->g, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($item->g, $this->genreBlacklist) ) { $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['r'] = $item->r; $result[] = $subArray; } $limitCount++; } } } } return $result; } function getRandomSongs($aVal) { $result = array(); $check = array(); if ($this->mediaBaseXML) { $count = count($this->mediaBaseXML->i); $max = ($count > $aVal) ? $aVal : $count; $ec = 0; $limit = $count * 10; while (count($result) < $max && $ec < $limit) { $rand = mt_rand(0, $count - 1); if ( (in_array($this->mediaBaseXML->i[$rand]->g, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($this->mediaBaseXML->i[$rand]->g, $this->genreBlacklist) && !in_array($this->mediaBaseXML->i[$rand]->g, $check) ) { $subArray = array(); $subArray['a'] = $this->mediaBaseXML->i[$rand]->a; $subArray['i'] = $this->mediaBaseXML->i[$rand]->i; $subArray['t'] = $this->mediaBaseXML->i[$rand]->t; $subArray['p'] = $this->mediaBaseXML->i[$rand]->p; $subArray['l'] = $this->mediaBaseXML->i[$rand]->l; $subArray['r'] = $this->mediaBaseXML->i[$rand]->r; $result[] = $subArray; $check[] = $this->mediaBaseXML->i[$rand]->a; } $ec++; } } return $result; } function getRandomSong() { $result = array(); if ($this->mediaBaseXML) { $count = count($this->mediaBaseXML->i); $rand = mt_rand(0, $count - 1); $curGenre = $this->mediaBaseXML->i[$rand]->g; if ($this->genreWhitelistActive) { $ec = 0; $limit = $count * 10; while ( (!in_array($curGenre, $this->genreWhitelist) || in_array($curGenre, $this->genreBlacklist) ) && $ec < $limit) { $rand = mt_rand(0, $count - 1); $curGenre = $this->mediaBaseXML->i[$rand]->g; $ec++; } } $result['a'] = $this->mediaBaseXML->i[$rand]->a; $result['i'] = $this->mediaBaseXML->i[$rand]->i; $result['t'] = $this->mediaBaseXML->i[$rand]->t; $result['p'] = $this->mediaBaseXML->i[$rand]->p; $result['l'] = $this->mediaBaseXML->i[$rand]->l; } return $result; } function getSongsByDate($aDate1, $aDate2, $aOffset = 0, $aLimit = 0) { $limitCount = $aOffset; $refCounter = 0; $past = intval($aDate1); $today = intval($aDate2); $result = array(); if ($this->mediaBaseXML) { foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; $year = substr($item->d, 0, 4); $month = substr($item->d, 5, 2); $day = substr($item->d, 8, 2); $fileDate = intval($year.$month.$day); if ($fileDate >= $past && $fileDate <= $today) { $refCounter++; if ($refCounter <= $aOffset) continue; if ( (in_array($item->g, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($item->g, $this->genreBlacklist) ) { $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['r'] = $item->r; $result[] = $subArray; } $limitCount++; } } } return $result; } function getTotalSongCount() { $result = QUESTMARK; if (@$this->mediaBaseXML) $result = count($this->mediaBaseXML->i); return $result; } function getSongInfo($aSong, $aFirstHit = false) { $attr = XML_BY; $found = false; $result = array(); if ($this->mediaBaseXML) { foreach($this->mediaBaseXML->i as $item) { $checkRef = ($aFirstHit) ? basename($item->a) : $item->a; if ($checkRef == $aSong) { $result['a'] = $item->a; $result['i'] = $item->i; $result['t'] = $item->t; $result['p'] = $item->p; $result['l'] = $item->l; $result['g'] = $item->g; $result['y'] = $item->y; $result['d'] = $item->d; { $result['r'] = $item->r; $result['rby'] = $item->r->attributes()->$attr; } { $result['c'] = $item->c; $result['cby'] = $item->c->attributes()->$attr; } $found = true; break; } } } return ($found) ? $result : $found; } function getVotedSongs($aOffset = 0, $aLimit = 0) { $limitCount = $aOffset; $refCounter = 0; $attr = XML_BY; $result = array(); if ($this->mediaBaseXML) { foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; if (trim($item->r) != NULLSTR OR trim($item->c) != NULLSTR) { $refCounter++; if ($refCounter <= $aOffset) continue; $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['g'] = $item->g; $subArray['y'] = $item->y; $subArray['d'] = $item->d; $subArray['r'] = $item->r; $subArray['rby'] = $item->r->attributes()->$attr; $subArray['c'] = $item->c; $subArray['cby'] = $item->c->attributes()->$attr; $result[] = $subArray; $limitCount++; } } } return $result; } function setSong($aSong) { if (CFG_DEBUG) echo cntLog('DEBUG aSong: '.$aSong, $this->depth); $this->curSongFound = false; $this->curSong = $aSong; if ($this->mediaBaseXML) { $i = 0; foreach ($this->mediaBaseXML->i as $item) { if (strcmp(basename($item->a), basename($this->curSong)) == 0) { $this->curSongFound = $i; break; } $i++; } } } function setComment($aComment, $aBy = NULLSTR) { $result = false; $attr = XML_BY; if ($this->curSongFound !== false) { $this->mediaBaseXML->i[$this->curSongFound]->c = htmlspecialchars( trim($aComment) ); $this->mediaBaseXML->i[$this->curSongFound]->c->attributes()->$attr = $aBy; cntLog('CHANGED COMMENT in mediaBase: "' . trim($aComment) . '" for song: ' . $this->curSong, $this->depth); $result = true; } else { $result = true; } return $result; } function setRating($aRating, $aBy = NULLSTR) { $result = false; $attr = XML_BY; if ($this->curSongFound !== false) { $this->mediaBaseXML->i[$this->curSongFound]->r = $aRating; $this->mediaBaseXML->i[$this->curSongFound]->r->attributes()->$attr = $aBy; cntLog('CHANGED RATING in mediaBase: "' . $aRating . '" for song: ' . $this->curSong, $this->depth); $result = true; } else { $result = true; } return $result; } function saveFeedback() { $result = false; $handle = fopen($this->mediabaseFile, 'wb'); if (!fwrite($handle, $this->mediaBaseXML->asXML())) { $this->lastMsg = LNG_ERR_UNKNOWN; cntLog('ERROR in function saveFeedback() in file api_mediabaseXML.php'); } else { $result = true; } fclose($handle); if ($result && CFG_DEBUG) cntMakeHumanXML($this->mediaBaseXML); return $result; } function findSong($aSong) { $result = false; if ($this->mediaBaseXML) { $attr = XML_BY; foreach ($this->mediaBaseXML->i as $item) { if (strcmp($item->a, $aSong) == 0) { if (isset($item->c)) { $this->curSongComment = $item->c; $this->curSongCommentBy = $item->c->attributes()->$attr; } if (isset($item->r)) { $this->curSongRating = $item->r; $this->curSongRatingBy = $item->r->attributes()->$attr; } $result = true; break; } } } return $result; } function getComment() { return $this->curSongComment; } function getCommentBy() { return $this->curSongCommentBy; } function getRating() { return $this->curSongRating; } function getRatingBy() { return $this->curSongRatingBy; } function findSongReset() { $this->curSongComment = NULLSTR; $this->curSongCommentBy = NULLSTR; $this->curSongRating = NULLSTR; $this->curSongRatingBy = NULLSTR; } } 