<?php 
 class class_mediaBase implements interface_mediabase { function __construct($aDepth = NULLSTR) { global $cfg_mySQL_host; global $cfg_mySQL_port; global $cfg_mySQL_user; global $cfg_mySQL_passwd; global $cfg_mySQL_dataBase; global $cfg_genreWhitelist; global $cfg_genreBlacklist; $this->depth = $aDepth; $this->dbconnected = false; $this->mySQL = new mysqli($cfg_mySQL_host, $cfg_mySQL_user, $cfg_mySQL_passwd, $cfg_mySQL_dataBase, $cfg_mySQL_port); if (mysqli_connect_errno()) { cntLog('mysql connection failed: '.mysqli_connect_error(), $this->depth); } else { $this->dbconnected = true; mysqli_set_charset($this->mySQL, 'utf8'); } $this->curSong = NULLSTR; $this->curSongFound = false; $this->findSongReset(); $this->genreWhitelist = $cfg_genreWhitelist; $this->genreWhitelistActive = (count($this->genreWhitelist) > 0 && trim($this->genreWhitelist[0]) != NULLSTR); $this->genreBlacklist = $cfg_genreBlacklist; } function getLastMsg() { return $this->lastMsg; } function query_getInterpretById($aId) { $queryInt = "SELECT `interpret` FROM `table_interpret` WHERE `id` = $aId"; $queryResult = $this->mySQL->query($queryInt); $obj = $queryResult->fetch_object(); if (isset($obj->interpret)) return $obj->interpret; else return QUESTMARK; } function query_getAlbumById($aId) { $queryInt = "SELECT `album` FROM `table_album` WHERE `id` = $aId"; $queryResult = $this->mySQL->query($queryInt); $obj = $queryResult->fetch_object(); if (isset($obj->album)) return $obj->album; else return NULLSTR; } function query_getGenreById($aId) { $queryInt = "SELECT `genre` FROM `table_genre` WHERE `id` = $aId"; $queryResult = $this->mySQL->query($queryInt); $obj = $queryResult->fetch_object(); if (isset($obj->genre)) return $obj->genre; else return NULLSTR; } function getSearchResult($aSeachStr, $aOffset = 0, $aLimit = 0, $aDL_level = false, $aCaseSensitive = false) { $aSeachStr = str_replace('*', '%', $aSeachStr); $limit = ($aLimit == 0) ? NULLSTR : ",$aLimit"; $result = array(); $query = "SELECT `absolute`,`interpretID`,`title`,`playtime`,`albumID`,`genreID`,`rating` FROM `table_base` WHERE `title` LIKE '%$aSeachStr%' OR `rating` LIKE '%$aSeachStr%' OR `ratingBy` LIKE '%$aSeachStr%' OR `comment` LIKE '%$aSeachStr%' OR `commentBy` LIKE '%$aSeachStr%' OR `year` LIKE '%$aSeachStr%' OR `interpretID` IN( SELECT `id` FROM `table_interpret` WHERE `interpret` LIKE '%$aSeachStr%' ) OR `albumID` IN( SELECT `id` FROM `table_album` WHERE `album` LIKE '%$aSeachStr%' ) OR `genreID` IN( SELECT `id` FROM `table_genre` WHERE `genre` LIKE '%$aSeachStr%' ) LIMIT $aOffset $limit "; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { $genre = $this->query_getGenreById($row->genreID); if ( (in_array($genre, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($genre, $this->genreBlacklist) ) { $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpretID)) ? $this->query_getInterpretById($row->interpretID) : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : NULLSTR; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->albumID)) ? $this->query_getAlbumById($row->albumID) : NULLSTR; $subArray['r'] = (isset($row->albumID)) ? $row->rating : NULLSTR; $result[] = $subArray; } } $queryResult->close(); return $result; } function getSearchResultByUser($aUser, $aOffset = 0, $aLimit = 0, $aCaseSensitive = false) { $result = array(); $aUser = str_replace('*', '%', $aUser); $limit = ($aLimit == 0) ? NULLSTR : ",$aLimit"; $query = "SELECT `absolute`,`interpretID`,`title`,`playtime`,`albumID`,`genreID`,`rating` FROM `table_base` WHERE `ratingBy` LIKE '%$aUser%' OR `commentBy` LIKE '%$aUser%' LIMIT $aOffset $limit"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { $genre = $this->query_getGenreById($row->genreID); if ( (in_array($genre, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($genre, $this->genreBlacklist) ) { $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpretID)) ? $this->query_getInterpretById($row->interpretID) : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : NULLSTR; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->albumID)) ? $this->query_getAlbumById($row->albumID) : NULLSTR; $subArray['r'] = (isset($row->rating)) ? $row->rating : NULLSTR; $result[] = $subArray; } } $queryResult->close(); return $result; } function getRandomSongs($aVal) { $result = array(); $ec = 0; $count = $this->getTotalSongCount(); $max = ($count > $aVal) ? $aVal : $count; $limit = $count; while (count($result) < $max && $ec < $limit) { $query = "SELECT `absolute`,`interpretID`,`title`,`playtime`,`albumID`,`genreID`,`rating` FROM `table_base` ORDER BY RAND() LIMIT $max"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { if (count($result) < $max) { $genre = $this->query_getGenreById($row->genreID); if ( (in_array($genre, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($genre, $this->genreBlacklist) ) { $subArray = array(); $subArray['a'] = $row->absolute; $subArray['i'] = $this->query_getInterpretById($row->interpretID); $subArray['t'] = $row->title; $subArray['p'] = $row->playtime; $subArray['l'] = $this->query_getAlbumById($row->albumID); $subArray['r'] = $row->rating; $result[] = $subArray; } } } $queryResult->close(); $ec++; } return $result; } function getRandomSong() { $result = array(); $ec = 0; $count = $this->getTotalSongCount(); $limit = $count * 10; while (count($result) < 1 && $ec < $limit) { $query = "SELECT `absolute`,`interpretID`,`title`,`playtime`,`albumID`,`genreID` FROM `table_base` ORDER BY RAND() LIMIT 1"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); $genre = $this->query_getGenreById($obj->genreID); if ( (in_array($genre, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($genre, $this->genreBlacklist) ) { $result['a'] = $obj->absolute; $result['i'] = $this->query_getInterpretById($obj->interpretID); $result['t'] = $obj->title; $result['p'] = $obj->playtime; $result['l'] = $this->query_getAlbumById($obj->albumID); } $queryResult->close(); $ec++; } return $result; } function getSongsByDate($aDate1, $aDate2, $aOffset = 0, $aLimit = 0) { $limitCount = $aOffset; $refCounter = 0; $result = array(); $past = intval($aDate1); $today = intval($aDate2); $query = "SELECT `absolute`,`interpretID`,`title`,`playtime`,`albumID`,`genreID`,`filedate`,`rating` FROM `table_base`"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; $year = substr($row->filedate, 0, 4); $month = substr($row->filedate, 5, 2); $day = substr($row->filedate, 8, 2); $fileDate = intval($year.$month.$day); if ($fileDate >= $past && $fileDate <= $today) { $refCounter++; if ($refCounter <= $aOffset) continue; $genre = $this->query_getGenreById($row->genreID); if ( (in_array($genre, $this->genreWhitelist) || !$this->genreWhitelistActive) && !in_array($genre, $this->genreBlacklist) ) { $subArray = array(); $subArray['a'] = $row->absolute; $subArray['i'] = $this->query_getInterpretById($row->interpretID); $subArray['t'] = $row->title; $subArray['p'] = $row->playtime; $subArray['l'] = $this->query_getAlbumById($row->albumID); $subArray['r'] = $row->rating; $result[] = $subArray; } $limitCount++; } } return $result; } function getTotalSongCount() { if (!$this->dbconnected) { return NULLINT; } else { $query = "SELECT MAX(`id`) AS `id` FROM `table_base`"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); return $obj->id; } } function getSongInfo($aSong, $aFirstHit = false) { $result = array(); $checkRef = ($aFirstHit) ? basename($aSong) : $aSong; $query = "SELECT * FROM `table_base` WHERE `absolute` = '$checkRef'"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); $result['a'] = (isset($obj->absolute)) ? $obj->absolute : NULLSTR; $result['i'] = (isset($obj->interpretID)) ? $this->query_getInterpretById($obj->interpretID) : QUESTMARK; $result['t'] = (isset($obj->title)) ? $obj->title : NULLSTR; $result['p'] = (isset($obj->playtime)) ? $obj->playtime : NULLSTR; $result['l'] = (isset($obj->albumID)) ? $this->query_getAlbumById($obj->albumID) : NULLSTR; $result['g'] = (isset($obj->genreID)) ? $this->query_getGenreById($obj->genreID) : NULLSTR; $result['y'] = (isset($obj->year)) ? $obj->year : NULLSTR; $result['d'] = (isset($obj->filedate)) ? $obj->filedate : NULLSTR; $result['r'] = (isset($obj->rating)) ? $obj->rating : NULLSTR; $result['rby'] = (isset($obj->ratingBy)) ? $obj->ratingBy : NULLSTR; $result['c'] = (isset($obj->comment)) ? $obj->comment : NULLSTR; $result['cby'] = (isset($obj->commentBy)) ? $obj->commentBy : NULLSTR; $queryResult->close(); return $result; } function getVotedSongs($aOffset = 0, $aLimit = 0) { $limitCount = $aOffset; $result = array(); $query = "SELECT * FROM `table_base` WHERE `rating` != '' OR `comment` != ''"; $queryResult = $this->mySQL->query($query); while ($row = $queryResult->fetch_object()) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; $subArray = array(); $subArray['a'] = (isset($row->absolute)) ? $row->absolute : NULLSTR; $subArray['i'] = (isset($row->interpretID)) ? $this->query_getInterpretById($row->interpretID) : QUESTMARK; $subArray['t'] = (isset($row->title)) ? $row->title : NULLSTR; $subArray['p'] = (isset($row->playtime)) ? $row->playtime : NULLSTR; $subArray['l'] = (isset($row->albumID)) ? $this->query_getAlbumById($row->albumID) : NULLSTR; $subArray['g'] = (isset($row->genreID)) ? $this->query_getGenreById($row->genreID) : NULLSTR; $subArray['y'] = (isset($row->year)) ? $row->year : NULLSTR; $subArray['d'] = (isset($row->filedate)) ? $row->filedate : NULLSTR; $subArray['r'] = (isset($row->rating)) ? $row->rating : NULLSTR; $subArray['rby'] = (isset($row->ratingBy)) ? $row->ratingBy : NULLSTR; $subArray['c'] = (isset($row->comment)) ? $row->comment : NULLSTR; $subArray['cby'] = (isset($row->commentBy)) ? $row->commentBy : NULLSTR; $result[] = $subArray; $limitCount++; } $queryResult->close(); return $result; } function setSong($aSong) { $this->curSong = $aSong; } function setComment($aComment, $aBy = NULLSTR) { $result = false; $comment = trim($aComment); $query = "UPDATE `table_base` SET `comment` = '$comment', `commentBy` = '$aBy' WHERE `table_base`.`absolute` LIKE '%$this->curSong';"; $queryResult = $this->mySQL->query($query); if ($queryResult) { cntLog('CHANGED COMMENT: "'.$comment.'" for song: '.$this->curSong); $result = true; } return $result; } function setRating($aRating, $aBy = NULLSTR) { $result = false; $query = "UPDATE `table_base` SET `rating` = '$aRating', `ratingBy` = '$aBy' WHERE `table_base`.`absolute` LIKE '%$this->curSong';"; $queryResult = $this->mySQL->query($query); if ($queryResult) { cntLog('CHANGED RATING: "'.$aRating.'" for song: '.$this->curSong); $result = true; } return $result; } function saveFeedback() { return true; } function findSong($aSong) { $query = "SELECT `rating`,`ratingBy`,`comment`,`commentBy` FROM `table_base` WHERE `absolute` LIKE '%$aSong'"; $queryResult = $this->mySQL->query($query); $obj = $queryResult->fetch_object(); $this->curSongRating = (isset($obj->rating)) ? $obj->rating : NULLSTR; $this->curSongRatingBy = (isset($obj->ratingBy)) ? $obj->ratingBy : NULLSTR; $this->curSongComment = (isset($obj->comment)) ? $obj->comment : NULLSTR; $this->curSongCommentBy = (isset($obj->commentBy)) ? $obj->commentBy : NULLSTR; $queryResult->close(); } function getComment() { return $this->curSongComment; } function getCommentBy() { return $this->curSongCommentBy; } function getRating() { return $this->curSongRating; } function getRatingBy() { return $this->curSongRatingBy; } function findSongReset() { $this->curSongComment = NULLSTR; $this->curSongCommentBy = NULLSTR; $this->curSongRating = NULLSTR; $this->curSongRatingBy = NULLSTR; } } 