<?php 
 class class_nickname { private $depth = NULLSTR; private $nickname = NULLSTR; private $nicknamePath = NULLSTR; private $allowMultiNickname = NULLSTR; private $clientIP = NULLSTR; private $lastDetectedNickIP = NULLSTR; private $silent = false; function __construct($depth = NULLSTR) { global $cfg_tmpPath; global $cfg_allowMultiNickname; $this->depth = $depth; $this->allowMultiNickname = $cfg_allowMultiNickname; $this->nicknamePath = $this->depth . $cfg_tmpPath . DIR_NICKNAMES; if (!is_dir($this->nicknamePath)) mkdir($this->nicknamePath); $this->clientIP = (isset($_SERVER['REMOTE_ADDR'])) ? $_SERVER['REMOTE_ADDR'] : QUESTMARK; $this->lastDetectedNickIP = NULLSTR; $this->nickname = NULLSTR; } function setSilent($value) { $this->silent = $value; } function getSilent() { return $this->silent; } private function _isValid($aNickname) { if ( $aNickname != '::1' && strtolower($aNickname) != 'localhost' && $aNickname != '127.0.0.1' && $aNickname != NICK_AUTO && $aNickname != NICK_TRIGGER && trim($aNickname) != NULLSTR ) { return true; } else { return false; } } private function _isFree($aNickname) { $check = scandir($this->nicknamePath); $nickIP = (file_exists($this->nicknamePath . $aNickname)) ? file_get_contents($this->nicknamePath . $aNickname) : false; $this->lastDetectedNickIP = $nickIP; if ( $this->allowMultiNickname || !in_array($aNickname, $check) || ($this->clientIP === $nickIP) || (isset($_SESSION['str_nickname']) && $_SESSION['str_nickname'] == $aNickname) ) { return true; } else { return false; } } function getNickname() { return $this->nickname; } function push($nickname, $current = NULLSTR) { $result = false; $nickname = trim($nickname); if (!$this->_isValid($nickname)) { eventLog(LNG_NICK_NOT_VALID . COLON . BLANK . $nickname, $this->depth); } else { if (!$this->_isFree($nickname)) { eventLog(LNG_NICK_ALREADY_USED.COLON.BLANK.$nickname.', on IP: '.$this->lastDetectedNickIP, $this->depth); } else { if ($current != NULLSTR) $this->dropForeign($current); if (!isset($_SESSION)) session_start(); $_SESSION['str_nickname'] = $nickname; $this->nickname = $nickname; file_put_contents($this->nicknamePath . $nickname, $this->clientIP); if (!$this->silent) eventLog('set nickname: ' . $nickname . ' (old: ' . $current . ')', $this->depth); $result = true; } } return $result; } function dropForeign($aNickname, $aDepth = NULLSTR) { $result = false; if (file_exists($this->nicknamePath . $aNickname) && !is_dir($this->nicknamePath . $aNickname)) { if (unlink($this->nicknamePath . $aNickname)) $result = true; else eventLog('failed to unlink hook from filesystem while loggin out: ' . $aNickname, $this->depth); } else eventLog('logged out: ' . $aNickname . ' (but nickname hook in filesystem was not available)', $this->depth); return $result; } function drop($nickname) { $result = false; session_unset(); if (!session_destroy()) { eventLog('failed to destroy session while loggin out: '.$nickname, $this->depth); } else { if (!file_exists($this->nicknamePath.$nickname) || is_dir($this->nicknamePath.$nickname)) { eventLog('logged out: '.$nickname.' (but nickname hook in filesystem was not available)', $this->depth); $result = true; } else { if (!unlink($this->nicknamePath.$nickname)) { eventLog('failed to unlink hook from filesystem while loggin out: '.$nickname, $this->depth); } else { eventLog('logged out: ' .$nickname, $this->depth); $result = true; } } } return $result; } static function showCurrentNicknames($depth = NULLSTR) { global $cfg_tmpPath; $output = NULLSTR; $nicknames = $depth.$cfg_tmpPath.DIR_NICKNAMES; if (is_dir($nicknames)) { $files = scandir($nicknames); if (count($files) > 2) { $output .= '<div class="takenNicknameArea centerAlignedBlock">'; $output .= '<div style="margin: 0em 0em 1em 1em; font-style: italic;">'.LNG_TAKEN_NICKNAMES.'</div>'; foreach($files as $nicks) { if (substr($nicks, 0, 1) != DOT) { $output .= '<div id="nickID'.$nicks.'" class="takenNicknames">'.cntMBL('<a class="linkNice" href="javascript:promptNickname(\''.$nicks.'\', 200)">'.$nicks.'</a>').'</div>'; } } $output .= '</div>'; } } return $output; } } 