<?php 
 class class_outputCache { private $allowed = false; private $lifetime = CACHELIFETIME_NORM; private $cachePath = NULLSTR; private $cacheFile = NULLSTR; private $fallback = NULLSTR; function __construct($aLifetime = CACHELIFETIME_LONG) { global $cfg_cachePath; global $cfg_cache; $this->allowed = ($cfg_cache) ? true : false; $this->lifetime = $aLifetime; $this->setCachePath($cfg_cachePath); } function getCacheAllowed() { return $this->allowed; } function getLifeTime() { return $this->lifetime; } function setLifeTime($aLifetime) { $this->lifetime = $aLifetime; } function getCachePath() { return $this->cachePath; } function setCachePath($aCachePath) { $this->cachePath = $aCachePath; } function setCacheFile($aCacheFile) { $this->cacheFile = $this->cachePath . $aCacheFile; } function addLanguage($aLang = LANG_EN) { if (isset($aLang) && !empty($aLang)) $this->setCachePath($this->cachePath .= $aLang . SLASH); else $this->setCachePath($this->cachePath .= LANG_EN . SLASH); } function _initCachePath($aCachePath) { if (!defined('RIGHTSOWNERONLY')) define('RIGHTSOWNERONLY', 0700); if (!is_Dir($aCachePath)) mkdir($aCachePath, RIGHTSOWNERONLY, true); } function putCacheContent($aContent) { if ($this->allowed) { $this->_initCachePath($this->cachePath); @file_put_contents($this->cacheFile, $aContent); } } function setFallback($aFallback) { $this->fallback = $aFallback; } function getFallback() { return $this->fallback; } function getCacheFile($basename = false) { if (!$basename) return $this->cacheFile; else return basename($this->cacheFile); } function getIsCacheFileAlive() { if (!$this->allowed) { return false; } else { if (!isset($this->cacheFile)) { return false; } else { if (!file_exists($this->cacheFile)) { return false; } else { return (cntGetTimeDiffAsSecondsFromUnix(filemtime($this->cacheFile)) < $this->lifetime) ? true : false; } } } } public static function stat_killCacheFile($aCacheFile) { global $cfg_cachePath; $fileToKill = $cfg_cachePath . $aCacheFile; if (file_exists($fileToKill)) { unlink($fileToKill); } else { $lang = (isset($_COOKIE[STR_LANG])) ? $_COOKIE[STR_LANG] : LANG_EN; $fileToKill = $cfg_cachePath . $lang . SLASH . $aCacheFile; if (file_exists($fileToKill)) unlink($fileToKill); } } public static function stat_killSpecialCacheFile($aCacheFile, $aCachePath = NULLSTR) { global $cfg_cachePath; if ($cfg_cachePath != NULLSTR) $fileToKill = $cfg_cachePath . SLASH . $aCacheFile; else $fileToKill = $cfg_cachePath . $aCacheFile; if (file_exists($fileToKill)) unlink($fileToKill); } } 