<?php 
 require_once ('defines.inc.php'); require_once ('keep/config.php'); require_once ('api_mediabase.php'); require_once ('lib/utils.php'); class class_playlist { private $PR_Song = NULLSTR; private $PR_Interpret = NULLSTR; private $PR_Title = NULLSTR; private $PR_Playtime = NULLSTR; private $PR_WishedBy = NULLSTR; private $PR_Album = NULLSTR; private $lastMsg = NULLSTR; public $wishedBy = NULLSTR; private $depth = NULLSTR; private $absSongLoc = NULLSTR; private $playlistFile = NULLSTR; private $allowMultibleEntries = NULLSTR; private $randomAfterLastSong = NULLSTR; private $maxEntries = NULLSTR; public $partyReport = NULLSTR; function __construct($aDepth = NULLSTR, $preventCreatingFiles = false) { global $cfg_absPathToSongs; global $cfg_playlistFile; global $cfg_allowMultiblePlaylistEntries; global $cfg_maxPlaylistEntries; global $cfg_partyReport; global $cfg_partyReportPath; global $cfg_partyMode; $this->depth = $aDepth; $this->absSongLoc = $cfg_absPathToSongs; $this->playlistFile = $aDepth . $cfg_playlistFile; $this->allowMultibleEntries = $cfg_allowMultiblePlaylistEntries; $this->randomAfterLastSong = $cfg_partyMode; $this->maxEntries = $cfg_maxPlaylistEntries; $this->partyReport = $cfg_partyReport; if (!$preventCreatingFiles) { if (!file_exists($this->playlistFile)) { $this->_createNew($this->playlistFile); } if (!is_dir($aDepth.$cfg_partyReportPath)) { mkdir($aDepth.$cfg_partyReportPath); } } } private function setLastMsg($lastMsg) { $this->lastMsg = $lastMsg; } public function getLastMsg() { return $this->lastMsg; } private function _createNew($aFile) { $newfile = fopen($aFile, 'w'); if ($newfile === false) { echo eventLog('could not create new playlist file in: '.__FUNCTION__); } else { fwrite($newfile, '<?xml version="1.0" encoding="UTF-8"?>'.LFC.'<playlist>'.LFC.'</playlist>'); fclose($newfile); } unset($newfile); } static private function _static_createNew($aFile) { $newfile = fopen($aFile, 'w'); if ($newfile === false) { echo eventLog('could not create new playlist file in: '.__FUNCTION__); } else { fwrite($newfile, '<?xml version="1.0" encoding="UTF-8"?>'.LFC.'<playlist>'.LFC.'</playlist>'); fclose($newfile); } unset($newfile); } private function _hitlist($aSongFile) { global $cfg_hitlistLimit; global $cfg_partyReportPath; $hitListFile = $cfg_partyReportPath.'hitlist.txt'; if (!file_exists($hitListFile)) file_put_contents($hitListFile, $aSongFile . LFC); else { $hitlist = file($hitListFile); $i = 0; $found = false; foreach ($hitlist as $hl) { if (trim($aSongFile) == trim($hl)) { $found = true; if ($i > 0) { $tmp = $hitlist[$i - 1]; $hitlist[$i - 1] = $aSongFile . LFC; $hitlist[$i + 0] = $tmp; } break; } $i++; } if (!$found) { if (count ($hitlist) > $cfg_hitlistLimit - 1) array_splice($hitlist, $cfg_hitlistLimit - 1); $x = round($i / 2); array_splice($hitlist, $x, 0, $aSongFile . "\n"); } file_put_contents($hitListFile, $hitlist); unset($hitlist); } } private function _partyReport_getFileName() { global $cfg_partyReportPath; if (!is_dir($cfg_partyReportPath)) { mkdir($cfg_partyReportPath); } $result = str_replace(DOT . cntGetFileExt($this->playlistFile), UNDSCR . date('Y-m-d') . '.xml', $this->playlistFile); return $cfg_partyReportPath . basename($result); } function partyReport_addSong($aSong, $aIN, $aTI, $aPT, $aAL, $aWB) { $this->PR_Song = $aSong; $this->PR_Interpret = $aIN; $this->PR_Title = $aTI; $this->PR_Playtime = $aPT; $this->PR_WishedBy = $aWB; $this->PR_Album = $aAL; } function partyReport_pushSong() { $partyReportFile = $this->_partyReport_getFileName(); if (!file_exists($partyReportFile)) { $this->_createNew($partyReportFile); } $xml = simplexml_load_file($partyReportFile); $item = $xml->addchild('item'); $nextFreeIndex = (string)$this->_getNextFreeIndex($partyReportFile); $item->addAttribute(XML_INDEX, $nextFreeIndex); $item->addchild('a', htmlspecialchars($this->PR_Song)); $item->addchild('i', htmlspecialchars($this->PR_Interpret)); $item->addchild('t', htmlspecialchars($this->PR_Title)); $item->addchild('p', $this->PR_Playtime); $item->addchild('w', htmlspecialchars($this->PR_WishedBy)); $item->addchild('l', htmlspecialchars($this->PR_Album)); $item->addchild('s', date('H:i:s')); if ($nextFreeIndex == NULLINT) { $handle = fopen($partyReportFile, 'w'); fwrite($handle, $xml->asXML()); fclose($handle); unset($xml); cntMakeHumanXML($partyReportFile); } if ($nextFreeIndex > NULLINT) { $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->loadXML($xml->asXML()); $xpath = new DomXPath($dom); $parent = $xpath->query('/playlist'); $queryOldTop = "//item[position() = 1]"; $queryNewTop = "//item[@".XML_INDEX." = $nextFreeIndex]"; $under = $xpath->query($queryNewTop); $above = $xpath->query($queryOldTop); $parent->item(0)->insertBefore($under->item(0), $above->item(0)); $dom->save($partyReportFile); } $this->_hitlist($this->PR_Song); } public static function stat_lastResult_pushSongs($aFileRef, $aResults, $aWishedBy) { self::_static_createNew($aFileRef); $xml = simplexml_load_file($aFileRef); foreach ($aResults as $result) { $item = $xml->addchild('item'); $item->addchild('a', htmlspecialchars($result['a'])); $item->addchild('i', htmlspecialchars($result['i'])); $item->addchild('t', htmlspecialchars($result['t'])); $item->addchild('p', $result['p']); $item->addchild('w', htmlspecialchars($aWishedBy)); $item->addchild('l', htmlspecialchars($result['l'])); $item->addchild('s', date('H:i:s')); $handle = fopen($aFileRef, 'w'); fwrite($handle, $xml->asXML()); fclose($handle); } } function clearPlaylist() { $result = LNG_ERR_UNKNOWN; $xml = simplexml_load_file($this->playlistFile); $count = count($xml->item); if ($xml) { $result = LNG_SUC; for ($i = 0; $i < $count; $i++) { if ($i > 0) { if (isset($xml->item[$i])) { $dom = dom_import_simplexml($xml->item[$i]); $dom->parentNode->removeChild($dom); $result = LNG_SUC_KILLED; $i--; } } } $handle = fopen($this->playlistFile, 'wb'); fwrite($handle, $xml->asXML()); fclose($handle); unset($xml); } return $result; } function removeDoubles() { $result = '<div style="font-weight: bold;">removing now double songs:</div><pre>'; $xml = simplexml_load_file($this->playlistFile); if ($xml) { $killed = array(); $attr = XML_INDEX; foreach ($xml->item as $item) { foreach ($xml->item as $item2) { $i1 = (string)$item->attributes()->$attr; $i2 = (string)$item2->attributes()->$attr; if ($i1 != $i2 && strcmp($item->a, $item2->a) === 0 && !in_array($i2, $killed)) { $this->removeSong($item->attributes()->$attr, true); if (!in_array($i1, $killed)) $result .= $item->a . ' i=' . $i1 . '<br>'; $killed[] = $i1; } } } } $result .= '</pre>'; unset($killed); return $result; } function removeCurNotAvailInFilesys() { global $cfg_absPathToSongs; $result = '<div style="font-weight: bold;">removing now songs which are not available in filesystem:</div><pre>'; $xml = simplexml_load_file($this->playlistFile); if ($xml) { $attr = XML_INDEX; foreach ($xml->item as $item) { if (!file_exists($cfg_absPathToSongs . $item->a)) { $this->removeSong($item->attributes()->$attr, true); $result .= $item->a . LFH; } } } $result .= '</pre>'; return $result; } private function _allowSongPush($aSong) { if ($this->allowMultibleEntries) return true; else { $found = false; $xml = simplexml_load_file($this->playlistFile); if ($xml) { foreach ($xml->item as $item) { if ($item->a == (string)$aSong) { $found = true; break; } } } return !$found; } } private function _checkForMaxEntries() { $result = false; $xml = simplexml_load_file($this->playlistFile); { if (empty($xml->item)) { $result = true; } else { $countCurrentPlaylistEntries = count($xml->item); if ($countCurrentPlaylistEntries <= $this->maxEntries) $result = true; } } unset($xml); return $result; } private function _getNextFreeIndex($aPlaylistFile) { $nextIndex = 0; $xml = simplexml_load_file($aPlaylistFile); if ($xml) { $attr = XML_INDEX; foreach ($xml->item as $item) { $checkIndex = intval($item->attributes()->$attr); if ($checkIndex >= $nextIndex) { $nextIndex = $checkIndex + 1; } } } return $nextIndex; } function setWishedBy($aWishedBy = NULLSTR) { $this->wishedBy = $aWishedBy; } function addSong($aSong, $aIN, $aTI, $aPT, $aAL, $aAdmin = false) { $result = false; if (!$aAdmin && !$this->_allowSongPush($aSong)) { $this->lastMsg = '<span class="msgAddFail">'.LNG_ALREADY_IN.'</span>'; } else { if (!$aAdmin && !$this->_checkForMaxEntries()) { $this->lastMsg = '<span class="msgAddFail">'.LNG_NO_MORE.'</span>'; } else { $xml = simplexml_load_file($this->playlistFile); { $item = $xml->addchild('item'); $nextFreeIndex = (string)$this->_getNextFreeIndex($this->playlistFile); $item->addAttribute(XML_INDEX, $nextFreeIndex); $item->addchild('a', htmlspecialchars($aSong)); $item->addchild('i', htmlspecialchars($aIN)); $item->addchild('t', htmlspecialchars($aTI)); $item->addchild('p', $aPT); $item->addchild('w', htmlspecialchars($this->wishedBy)); $item->addchild('l', htmlspecialchars($aAL)); $handle = fopen($this->playlistFile, 'wb'); if (fwrite($handle, $xml->asXML())) fclose($handle); else $this->lastMsg = cntErrMsg(LNG_ERR_WRITEFILE); unset($xml); } if (!cntMakeHumanXML($this->playlistFile)) { $this->lastMsg = LNG_ERR_HUMANFORMAT; } else { $this->lastMsg = LNG_SUC_ADDED; $result = true; } } } return $result; } function removeSong($aIndex, $aAdmin) { $result = false; $this->lastMsg = LNG_ERR_UNKNOWN; if (!$aAdmin) { $this->lastMsg = cntErrMsg(LNG_ERR_ONLYADMIN); } else { $xml = simplexml_load_file($this->playlistFile); if ($xml) { $attr = XML_INDEX; foreach ($xml->item as $item) { if ($item->attributes()->$attr == (string)$aIndex) { $dom = dom_import_simplexml($item); $dom->parentNode->removeChild($dom); $this->lastMsg = LNG_SUC_KILLED; $result = true; break; } } $handle = fopen($this->playlistFile, 'wb'); fwrite($handle, $xml->asXML()); fclose($handle); unset($xml); } } return $result; } function stashPushSong($aIndex, $aNickname, $aA, $aI, $aT, $aP, $aL) { global $cfg_tmpPathStatic; $result = false; $stashfile = $cfg_tmpPathStatic.DIR_STASH.$aNickname; if (!file_exists($stashfile)) { if (!(is_dir($cfg_tmpPathStatic.DIR_STASH))) mkdir($cfg_tmpPathStatic.DIR_STASH); $this->_createNew($stashfile); } $xml = simplexml_load_file($stashfile); if ($xml) { $item = $xml->addchild('item'); $nextFreeIndex = (string)$this->_getNextFreeIndex($stashfile); $item->addAttribute(XML_INDEX, $nextFreeIndex); $item->addchild('a', htmlspecialchars($aA)); $item->addchild('i', htmlspecialchars($aI)); $item->addchild('t', htmlspecialchars($aT)); $item->addchild('p', $aP); $item->addchild('w', htmlspecialchars($aNickname)); $item->addchild('l', htmlspecialchars($aL)); $handle = fopen($stashfile, 'wb'); if (fwrite($handle, $xml->asXML())) fclose($handle); else $this->lastMsg = cntErrMsg(LNG_ERR_WRITEFILE); unset($xml); } if (!cntMakeHumanXML($stashfile)) { $this->lastMsg = LNG_ERR_HUMANFORMAT; } else { $this->lastMsg = LNG_SUC_ADDED; $result = true; } return $result; } function stashPopSong($aNickname, $aIndex = false) { global $cfg_tmpPathStatic; $result = array(); $this->lastMsg = LNG_STASH_POP_FAILED; $stashfile = $cfg_tmpPathStatic.DIR_STASH.$aNickname; if (!file_exists($stashfile)) { $this->lastMsg = LNG_STASH_NO_SONG; } else { $xml = simplexml_load_file($stashfile); if ($xml) { $count = count($xml); if (!($count > 0)) { $this->lastMsg = LNG_STASH_NO_SONG; } else { if ($aIndex === false) { $songID = $count-1; $result['a'] = $xml->item[$songID]->a; $result['i'] = $xml->item[$songID]->i; $result['t'] = $xml->item[$songID]->t; $result['p'] = $xml->item[$songID]->p; $result['l'] = $xml->item[$songID]->l; } else { $i = 0; $attr = XML_INDEX; foreach ($xml->item as $item) { if ($item->attributes()->$attr == (string)$aIndex) { $result['a'] = $xml->item[$i]->a; $result['i'] = $xml->item[$i]->i; $result['t'] = $xml->item[$i]->t; $result['p'] = $xml->item[$i]->p; $result['l'] = $xml->item[$i]->l; break; } $i++; } $songID = $i; } $dom = dom_import_simplexml($xml->item[$songID]); $dom->parentNode->removeChild($dom); $this->lastMsg = LNG_SUC_KILLED; $handle = fopen($stashfile, 'wb'); fwrite($handle, $xml->asXML()); fclose($handle); unset($xml); if (!cntMakeHumanXML($stashfile)) { $this->lastMsg = LNG_ERR_HUMANFORMAT; } else { $this->lastMsg = LNG_SUC_ADDED; } } } } return $result; } function stashGetContent($aNickname) { global $cfg_tmpPathStatic; $result = array(); $stashfile = $cfg_tmpPathStatic.DIR_STASH.$aNickname; if (!file_exists($stashfile)) { $this->lastMsg = LNG_STASH_NO_SONG; } else { $xml = simplexml_load_file($stashfile); if ($xml) { $count = count($xml); if (!($count > 0)) { $this->lastMsg = LNG_STASH_NO_SONG; } else { $attr = XML_INDEX; foreach ($xml->item as $item) { $songIndex = intval($item->attributes()->$attr); $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $result[$songIndex] = $subArray; } } } } return $result; } function getNextSong() { if (!file_exists($this->playlistFile)) $this->_createNew($this->playlistFile); $xml = simplexml_load_file($this->playlistFile); { $result = $xml->item->a; if (empty($result) && $this->randomAfterLastSong) { $myMediaBase = new class_mediaBase(); $rand = $myMediaBase->getRandomSong(); unset($myMediaBase); $this->setWishedBy(NICK_AUTO); $this->addSong($rand['a'], $rand['i'], $rand['t'], $rand['p'], $rand['l']); $result = $rand['a']; $this->pushPlayerRemainTime(parseHumanMinSecStringToSeconds($rand['p'])); if ($this->partyReport) { $this->partyReport_addSong($rand['a'], $rand['i'], $rand['t'], $rand['p'], $rand['l'], $this->wishedBy); } $this->setWishedBy(NULLSTR); } else { $this->pushPlayerRemainTime(parseHumanMinSecStringToSeconds($xml->item->p)); if ($this->partyReport) { $this->partyReport_addSong($xml->item->a, $xml->item->i, $xml->item->t, $xml->item->p, $xml->item->l, $xml->item->w); } } unset($xml); return $this->absSongLoc . $result; } } function removePlayedSong() { if (file_exists($this->playlistFile)) { $xml = simplexml_load_file($this->playlistFile); if ($xml) { if ($xml->item[0]) { $dom = dom_import_simplexml($xml->item[0]); $dom->parentNode->removeChild($dom); $handle = fopen($this->playlistFile, 'wb'); fwrite($handle, $xml->asXML()); fclose($handle); unset($xml); } } } } function getWholePlaylist($onlyOnAir = false) { $result = array(); try { $xml = @simplexml_load_file($this->playlistFile); if (!$xml) { throw new Exception("Failed to load XML file"); } foreach ($xml->item as $item) { $subArray = array(); $attr = XML_INDEX; $subArray[XML_INDEX] = $item->attributes()->$attr; $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['w'] = $item->w; $subArray['l'] = $item->l; $result[] = $subArray; if ($onlyOnAir) break; } unset($xml); } catch (Exception $e) { eventLog('Failure in getWholePlaylist(): ' . $e->getMessage(), $this->depth); } return $result; } function getWholePlaylistAsJson(class_player $player, bool $asString = false): array|string { $json[JSON_RC] = JSON_RC_OK; $songs = $this->getWholePlaylist(); $i = 0; foreach ($songs as $song) { if ($i == 0) { $onAirRealRemainTime = parseSecondsToHumanMinSecString($this->getPlayerRemainTime()); if ($onAirRealRemainTime !== false) { $tmp = array('id' => intval($song[XML_INDEX]), 'a' => (string)$song['a'], 'i' => (string)$song['i'], 't' => (string)$song['t'], 'p' => (string)$onAirRealRemainTime, 'w' => (string)$song['w'], 'l' => (string)$song['l'] ); $curPos = $onAirRealRemainTime; } else { $tmp = array('id' => intval($song[XML_INDEX]), 'a' => (string)$song['a'], 'i' => (string)$song['i'], 't' => (string)$song['t'], 'p' => (string)$song['p'], 'w' => (string)$song['w'], 'l' => (string)$song['l'] ); $curPos = 0; } $json['onAir'] = $tmp; $json[JSON_RC_STATE] = $player->getPlayerState(); $json['onAirCurPos'] = getSecondsPerMinSec($curPos); $json['onAirLength'] = getSecondsPerMinSec($song['p']); $json['count'] = count($songs); } else { $eta = $this->getEstimatedPlaytime($song[XML_INDEX]); $tmp = array('id' => intval($song[XML_INDEX]), 'a' => (string)$song['a'], 'i' => (string)$song['i'], 't' => (string)$song['t'], 'p' => (string)$eta, 'w' => (string)$song['w'], 'l' => (string)$song['l'] ); $playlist[] = $tmp; } $i++; } if (!empty($playlist)) { $json['playlist'] = $playlist; } if ($asString) { return json_encode($json); } else { return $json; } } function getPlaylistCount() { $result = '0'; $xml = simplexml_load_file($this->playlistFile); if ($xml) { $count = count($xml->item); $result = ($count > 0) ? $count - 1 : $count; } unset($xml); return $result; } function moveDownSong($aIndex, $aAdmin) { $result = false; if ($aAdmin) { $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->load($this->playlistFile); $xpath = new DomXPath($dom); $parent = $xpath->query('/playlist'); $query1 = "//item[@".XML_INDEX." = $aIndex]"; $under = $xpath->query($query1); try { @$parent->item(0)->insertBefore($under->item(0)->nextSibling, $under->item(0)); if ($dom->save($this->playlistFile)) $result = true; } catch (Exception $e) { } } return $result; } function moveUpSong(mixed $aIndex, bool $aAdmin, string $aFile = NULLSTR): bool { $result = false; if ($aAdmin) { require_once $this->depth.'api_player.php'; $playerState = class_player::static_getPlayerState(); if ($playerState == PS_OFF) { $file = (empty($aFile)) ? $this->playlistFile : $aFile; $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->load($file); $xpath = new DomXPath($dom); $parent = $xpath->query('/playlist'); $query1 = "//item[@".XML_INDEX." = $aIndex]"; $under = $xpath->query($query1); if ($under->length > 0 && $parent->item(0)->firstChild !== $under->item(0)) { $parent->item(0)->insertBefore($under->item(0), $under->item(0)->previousSibling); if ($dom->save($file)) { $result = true; } } } else { $file = (empty($aFile)) ? $this->playlistFile : $aFile; $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->load($file); $xpath = new DomXPath($dom); $parent = $xpath->query('/playlist'); $query1 = "//item[@".XML_INDEX." = $aIndex]"; $under = $xpath->query($query1); if ($under->length > 0) { $currentNode = $under->item(0); $previousSibling = $currentNode->previousSibling; if ($previousSibling !== null) { if ($parent->item(0)->firstChild !== $previousSibling) { $parent->item(0)->insertBefore($currentNode, $previousSibling); } if ($dom->save($file)) { $result = true; } } } } } return $result; } function moveTopSong($aIndex, $aAdmin) { $result = false; if ($aAdmin) { $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->load($this->playlistFile); $xpath = new DomXPath($dom); $parent = $xpath->query('/playlist')->item(0); $queryNewTop = "//item[@".XML_INDEX." = $aIndex]"; $under = $xpath->query($queryNewTop)->item(0); $secondItem = $xpath->query('//item[position() = 2]')->item(0); $firstItem = $xpath->query('//item[position() = 1]')->item(0); if ($under && $secondItem && $firstItem) { if ($under->isSameNode($firstItem)) { return false; } if ($under->isSameNode($secondItem)) { return true; } $parent->insertBefore($under, $secondItem); if ($dom->save($this->playlistFile)) { $result = true; } } } return $result; } function moveBottomTopSong($aAdmin) { $result = false; if ($aAdmin) { $plc = $this->getPlaylistCount(); if ($plc > 1) { $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->load($this->playlistFile); $xpath = new DomXPath($dom); $parent = $xpath->query('/playlist'); $queryOldTop = "//item[position() = 2]"; $lastSongPos = $plc + 1; $queryNewTop = "//item[position() = $lastSongPos]"; $under = $xpath->query($queryNewTop); $above = $xpath->query($queryOldTop); if (true) { $parent->item(0)->insertBefore($under->item(0), $above->item(0)); if ($dom->save($this->playlistFile)) { $result = true; } } } } return $result; } function duplicateOnAirInCue() { $result = false; $dom = new DomDocument(); $dom->formatOutput = true; $dom->preserveWhiteSpace = false; $dom->load($this->playlistFile); $xpath = new DomXPath($dom); $parent = $xpath->query('/playlist'); $queryOnAir = "//item[position() = 1]"; $onAir = $xpath->query($queryOnAir); $clonenode = $onAir->item(0)->cloneNode(true); $parent->item(0)->insertBefore($clonenode, $onAir->item(0)); if ($dom->save($this->playlistFile)) $result = true; return $result; } function pushPlayerRemainTime($seconds) { global $cfg_playerRemainTime_abs; return file_put_contents($this->depth.$cfg_playerRemainTime_abs, $seconds); } function getPlayerRemainTime() { global $cfg_playerRemainTime; if (!file_exists($this->depth.$cfg_playerRemainTime)) { eventLog('file does not exist in getPlayerRemainTime(): '.$this->depth.$cfg_playerRemainTime, $this->depth); return 0; } else { return trim(file_get_contents($this->depth.$cfg_playerRemainTime)); } } private function _addPLTime($aTime1, $aTime2) { $h = strtotime($aTime1); $h2 = strtotime($aTime2); $minute = date('i', $h2); $second = date('s', $h2); $hour = date('H', $h2); $convert = strtotime("+$minute minutes", $h); $convert = strtotime("+$second seconds", $convert); $convert = strtotime("+$hour hours", $convert); return date('H:i:s', $convert); } function getEstimatedPlaytime($aIndex) { $result = TILDE; $count = '0:0:0'; try { $xml = @simplexml_load_file($this->playlistFile); if (!$xml) { throw new Exception("Failed to load XML file"); } $onAir = true; $attr = XML_INDEX; foreach ($xml->item as $item) { if ($item->attributes()->$attr == (string)$aIndex) break; if ($onAir) { $onAir = false; $count = $this->_addPLTime($count, '0:' . parseSecondsToHumanMinSecString($this->getPlayerRemainTime())); } else { $count = $this->_addPLTime($count, '0:' . $item->p[0]); } } $result = $count; unset($xml); } catch (Exception $e) { eventLog('Failure in getEstimatedPlaytime(): ' . $e->getMessage(), $this->depth); } return $result; } } 