<?php 
 class class_mediaBase implements interface_mediabase { private $depth = NULLSTR; private $mediabaseFile = NULLSTR; private $mediaBaseXML; private $curSong = NULLSTR; private $curSongFound = false; private $lastMsg = NULLSTR; private $genreWhitelist; private $genreWhitelistActive; private $genreBlacklist; private $rateWhitelist; private $rateWhitelistActive; private $rateBlacklist; function __construct($aDepth = NULLSTR) { global $cfg_mediabaseFile; global $cfg_genreWhitelist, $cfg_genreBlacklist; global $cfg_rateWhitelist, $cfg_rateBlacklist; $this->depth = $aDepth; $this->mediabaseFile = $this->depth . $cfg_mediabaseFile; if (file_exists($this->mediabaseFile)) { $this->mediaBaseXML = simplexml_load_file($this->mediabaseFile); } else { echo ('<span style="color: red;">' . $this->mediabaseFile . ' is not available, please import your songs with the <span style="color: blue; font-weight: bold;">blue button</span>...</span>'); } $this->findSongReset(); $this->genreWhitelist = $cfg_genreWhitelist; $this->genreWhitelistActive = (count($this->genreWhitelist) > 0 && trim($this->genreWhitelist[0]) != NULLSTR); $this->genreBlacklist = $cfg_genreBlacklist; $this->rateWhitelist = $cfg_rateWhitelist; $this->rateWhitelistActive = (count($this->rateWhitelist) > 0 && trim($this->rateWhitelist[0]) != NULLSTR); $this->rateBlacklist = $cfg_rateBlacklist; } function getLastMsg() { return $this->lastMsg; } function getSearchResult($aSeachStr, $aOffset = 0, $aLimit = 0, $aDL_level = false, $aCaseSensitive = false) { global $cfg_minimumSearchChars; $result = array(); $limitCount = $aOffset; $refCounter = 0; if (strlen($aSeachStr) >= $cfg_minimumSearchChars) { if ($this->mediaBaseXML) { $soPatLen = strlen(SO_INTERPRET); $checkSearchParam = substr($aSeachStr, 0, $soPatLen); switch ($checkSearchParam) { case SO_INTERPRET: case SO_TITLE: case SO_ALBUM: case SO_GENRE: case SO_COMMENT: { $seachStr = substr($aSeachStr, $soPatLen); break; } default: { $seachStr = $aSeachStr; } } $attr = XML_BY; foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) { break; } switch ($checkSearchParam) { case SO_INTERPRET: { $songHulk = ($item->i) . BLANK . ($item->r); break; } case SO_TITLE: { $songHulk = ($item->t) . BLANK . ($item->r); break; } case SO_ALBUM: { $songHulk = ($item->l) . BLANK . ($item->r); break; } case SO_GENRE: { $songHulk = ($item->g) . BLANK . ($item->r); break; } case SO_COMMENT: { $songHulk = ($item->c) . BLANK . ($item->r); break; } default: { $songHulk = ($item->i) . BLANK . ($item->t) . BLANK . ($item->l) . BLANK . ($item->g) . BLANK . ($item->y) . BLANK . ($item->r) . BLANK . ($item->r->attributes()->$attr) . BLANK . ($item->c) . BLANK . ($item->c->attributes()->$attr); } } $songHulkDecoded = html_entity_decode($songHulk, ENT_QUOTES | ENT_IGNORE, 'UTF-8'); $caseSensitive = ($aCaseSensitive) ? NULLINT : FNM_CASEFOLD; $check = (fnmatch('*' . cntTrim($seachStr) . '*', $songHulkDecoded, $caseSensitive)); if ($aDL_level > 0) { $DL_in = levenshtein($seachStr, html_entity_decode($item->i, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); $DL_ti = levenshtein($seachStr, html_entity_decode($item->t, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); $DL_al = levenshtein($seachStr, html_entity_decode($item->l, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); $DL_ge = levenshtein($seachStr, html_entity_decode($item->g, ENT_QUOTES | ENT_IGNORE, 'UTF-8')); if ($DL_in <= $aDL_level || $DL_ti <= $aDL_level || $DL_al <= $aDL_level || $DL_ge <= $aDL_level) { $check = true; } } if ($check !== false) { $refCounter++; if ($refCounter <= $aOffset) { continue; } if ( !in_array($item->g, $this->genreBlacklist) && (!$this->genreWhitelistActive || in_array($item->g, $this->genreWhitelist)) ) { $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['r'] = $item->r; $subArray['c'] = $item->c; $result[] = $subArray; } $limitCount++; } } } } return $result; } function getSearchResultByUser($aUser, $aOffset = 0, $aLimit = 0, $aCaseSensitive = false) { global $cfg_minimumSearchChars; $limitCount = $aOffset; $refCounter = 0; $result = array(); if (strlen($aUser) >= $cfg_minimumSearchChars) { if ($this->mediaBaseXML) { $attr = XML_BY; foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; $songHulk = ($item->r->attributes()->$attr) . BLANK . ($item->c->attributes()->$attr); $songHulkDecoded = html_entity_decode($songHulk, ENT_QUOTES | ENT_IGNORE, 'UTF-8'); $caseSensitive = ($aCaseSensitive) ? NULLINT : FNM_CASEFOLD; $check = (fnmatch('*' . cntTrim($aUser) . '*', $songHulkDecoded, $caseSensitive)); if ($check !== false) { $refCounter++; if ($refCounter <= $aOffset) continue; if ( !in_array($item->g, $this->genreBlacklist) && (!$this->genreWhitelistActive || in_array($item->g, $this->genreWhitelist)) ) { $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['r'] = $item->r; $subArray['c'] = $item->c; $result[] = $subArray; } $limitCount++; } } } } return $result; } function getSongsByDate($aDate1, $aDate2, $aOffset = 0, $aLimit = 0) { $result = array(); $limitCount = $aOffset; $refCounter = 0; $past = intval($aDate1); $today = intval($aDate2); if ($this->mediaBaseXML) { foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; $year = substr($item->d, 0, 4); $month = substr($item->d, 5, 2); $day = substr($item->d, 8, 2); $fileDate = intval($year.$month.$day); if ($fileDate >= $past && $fileDate <= $today) { $refCounter++; if ($refCounter <= $aOffset) continue; if ( !in_array($item->g, $this->genreBlacklist) && (!$this->genreWhitelistActive || in_array($item->g, $this->genreWhitelist)) ) { $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['r'] = $item->r; $subArray['c'] = $item->c; $result[] = $subArray; } $limitCount++; } } } return $result; } function getRandomSongs($number) { $result = array(); $check = array(); if ($this->mediaBaseXML) { $count = count($this->mediaBaseXML->i); $max = ($count > $number) ? $number : $count; $ec = 0; $el = util_calcMaxRetryCounter($count); while (count($result) < $max && $ec < $el) { $rand = mt_rand(0, $count - 1); $curGenre = $this->mediaBaseXML->i[$rand]->g; if ( (!in_array($curGenre, $check)) && (!in_array($curGenre, $this->genreBlacklist)) && (!$this->genreWhitelistActive || in_array($curGenre, $this->genreWhitelist)) ) { $subArray = array(); $subArray['a'] = $this->mediaBaseXML->i[$rand]->a; $subArray['i'] = $this->mediaBaseXML->i[$rand]->i; $subArray['t'] = $this->mediaBaseXML->i[$rand]->t; $subArray['p'] = $this->mediaBaseXML->i[$rand]->p; $subArray['l'] = $this->mediaBaseXML->i[$rand]->l; $subArray['r'] = $this->mediaBaseXML->i[$rand]->r; $subArray['c'] = $this->mediaBaseXML->i[$rand]->c; $result[] = $subArray; $check[] = $this->mediaBaseXML->i[$rand]->a; } $ec++; } } return $result; } function getRandomSong() { $result = array(); if ($this->mediaBaseXML) { $count = count($this->mediaBaseXML->i); $rand = mt_rand(0, $count - 1); $ec = 0; $el = util_calcMaxRetryCounter($count); while ($ec < $el && ( in_array($this->mediaBaseXML->i[$rand]->g, $this->genreBlacklist) || ($this->genreWhitelistActive && !in_array($this->mediaBaseXML->i[$rand]->g, $this->genreWhitelist)) || in_array($this->mediaBaseXML->i[$rand]->r, $this->rateBlacklist) || ($this->rateWhitelistActive && !in_array($this->mediaBaseXML->i[$rand]->r, $this->rateWhitelist)) ) ) { $rand = mt_rand(0, $count - 1); $ec++; } $result['a'] = $this->mediaBaseXML->i[$rand]->a; $result['i'] = $this->mediaBaseXML->i[$rand]->i; $result['t'] = $this->mediaBaseXML->i[$rand]->t; $result['p'] = $this->mediaBaseXML->i[$rand]->p; $result['l'] = $this->mediaBaseXML->i[$rand]->l; } return $result; } function getTotalSongCount() { $result = QUESTMARK; if (@$this->mediaBaseXML) $result = count($this->mediaBaseXML->i); return $result; } function getSongInfo($aSong, $aFirstHit = false) { $attr = XML_BY; $found = false; $result = array(); if ($this->mediaBaseXML) { foreach($this->mediaBaseXML->i as $item) { $checkRef = ($aFirstHit) ? basename($item->a) : $item->a; if ($checkRef == $aSong) { $result['a'] = $item->a; $result['i'] = $item->i; $result['t'] = $item->t; $result['p'] = $item->p; $result['l'] = $item->l; $result['g'] = $item->g; $result['y'] = $item->y; $result['d'] = $item->d; { $result['r'] = $item->r; $result['rby'] = $item->r->attributes()->$attr; } { $result['c'] = $item->c; $result['cby'] = $item->c->attributes()->$attr; } $found = true; break; } } } return ($found) ? $result : $found; } function getVotedSongs($aOffset = 0, $aLimit = 0) { $result = array(); $limitCount = $aOffset; $refCounter = 0; $attr = XML_BY; if ($this->mediaBaseXML) { foreach($this->mediaBaseXML->i as $item) { if ($aLimit > 0 && $limitCount >= $aLimit + $aOffset) break; if (trim($item->r) != NULLSTR OR trim($item->c) != NULLSTR) { $refCounter++; if ($refCounter <= $aOffset) continue; $subArray = array(); $subArray['a'] = $item->a; $subArray['i'] = $item->i; $subArray['t'] = $item->t; $subArray['p'] = $item->p; $subArray['l'] = $item->l; $subArray['g'] = $item->g; $subArray['y'] = $item->y; $subArray['d'] = $item->d; $subArray['r'] = $item->r; $subArray['rby'] = $item->r->attributes()->$attr; $subArray['c'] = $item->c; $subArray['cby'] = $item->c->attributes()->$attr; $result[] = $subArray; $limitCount++; } } } return $result; } function setSong($aSong) { if (CFG_DEBUG) echo eventLog('DEBUG aSong: '.$aSong, $this->depth); $this->curSongFound = false; $this->curSong = $aSong; if ($this->mediaBaseXML) { $i = 0; foreach ($this->mediaBaseXML->i as $item) { if (strcmp(basename($item->a), basename($this->curSong)) == 0) { $this->curSongFound = $i; break; } $i++; } } } function setComment($aComment, $aBy = NULLSTR) { $result = false; $attr = XML_BY; if ($this->curSongFound !== false) { $this->mediaBaseXML->i[$this->curSongFound]->c = htmlspecialchars( trim($aComment) ); $this->mediaBaseXML->i[$this->curSongFound]->c->attributes()->$attr = $aBy; eventLog('CHANGED COMMENT in mediaBase: "' . trim($aComment) . '" for song: ' . $this->curSong, $this->depth); $result = true; } else { $result = true; } return $result; } function setRating($aRating, $aBy = NULLSTR) { $result = false; $attr = XML_BY; if ($this->curSongFound !== false) { $this->mediaBaseXML->i[$this->curSongFound]->r = $aRating; $this->mediaBaseXML->i[$this->curSongFound]->r->attributes()->$attr = $aBy; eventLog('CHANGED RATING in mediaBase: "' . $aRating . '" for song: ' . $this->curSong, $this->depth); $result = true; } else { $result = true; } return $result; } function saveFeedback() { $result = false; $handle = fopen($this->mediabaseFile, 'wb'); if (!fwrite($handle, $this->mediaBaseXML->asXML())) { $this->lastMsg = LNG_ERR_UNKNOWN; eventLog('ERROR in function saveFeedback() in file api_mediabaseXML.php'); } else { $result = true; } fclose($handle); if ($result && CFG_DEBUG) cntMakeHumanXML($this->mediaBaseXML); return $result; } function findSong($aSong) { $result = false; if ($this->mediaBaseXML) { $attr = XML_BY; foreach ($this->mediaBaseXML->i as $item) { if (strcmp($item->a, $aSong) == 0) { if (isset($item->c)) { $this->curSongComment = $item->c; $this->curSongCommentBy = $item->c->attributes()->$attr; } if (isset($item->r)) { $this->curSongRating = $item->r; $this->curSongRatingBy = $item->r->attributes()->$attr; } $result = true; break; } } } return $result; } function getComment() { return $this->curSongComment; } function getCommentBy() { return $this->curSongCommentBy; } function getRating() { return $this->curSongRating; } function getRatingBy() { return $this->curSongRatingBy; } function findSongReset() { $this->curSongComment = NULLSTR; $this->curSongCommentBy = NULLSTR; $this->curSongRating = NULLSTR; $this->curSongRatingBy = NULLSTR; } } 